;
; *** Listing 13-2 ***
;
; Generates the cumulative exclusive-or of all bytes in a
; 64-byte block of memory by replicating the exclusive-or
; code 64 times and then executing all 64 instances in a
; row without branching.
;
	jmp	Skip
;
; The 64-byte block for which to generate the cumulative
; exclusive-or.
;
X=1
ByteArray	label	byte
	rept	64
	db	X
X=X+1
	endm
;
; Generates the cumulative exclusive-or of all bytes in a
; 64-byte memory block.
;
; Input:
;	SI = pointer to start of 64-byte block for which to
;		calculate cumulative exclusive-or
;
; Output:
;	AH = cumulative exclusive-or of all bytes in the
;		64-byte block
;
; Registers altered: AX, SI
;
CumulativeXor:
	sub	ah,ah	;initialize our cumulative XOR to 0
	rept	64
	lodsb		;get the next byte and
	xor	ah,al	; XOR it into the cumulative result
	endm
	ret
;
Skip:
	call	ZTimerOn
	cld
	mov	si,offset ByteArray
				;point to the 64-byte block
	call	CumulativeXor	;get the cumulative XOR
	call	ZTimerOff
