;
; *** Listing 13-21 ***
;
; Replacement code for XorImage in Listing 11-33.
; This version uses in-line code to eliminate branching
; during the drawing of each image line.
;----------------------------------------------------------
; Exclusive-ors the image of a 3-color square at the
; specified screen location. Assumes images start on
; even-numbered scan lines and are an even number of
; scan lines high. Always draws images byte-aligned in
; display memory.
;
; Input:
;	CX = X coordinate of upper left corner at which to
;		draw image (will be adjusted to nearest
;		less-than or equal-to multiple of 4 in order
;		to byte-align)
;	DX = Y coordinate of upper left corner at which to
;		draw image
;	ES = display memory segment
;
; Output: none
;
; Registers altered: AX, CX, DX, SI, DI, BP
;
XorImage:
	shr	dx,1	;divide the row # by 2 to compensate
			; for the 2-bank nature of 320x200
			; 4-color mode
	mov	ax,SCREEN_WIDTH
	mul	dx	;start offset of top row of image in
			; display memory
	shr	cx,1	;divide the X coordinate by 4
	shr	cx,1	; because there are 4 pixels per
			; byte
	add	ax,cx	;point to the offset at which the
			; upper left byte of the image will
			; go
	mov	di,ax
	mov	si,offset TheImage
			;point to the start of the one image
			; we always draw
	mov	dx,BANK_OFFSET-IMAGE_WIDTH
			;offset from the end of an even line
			; of the image in display memory to
			; the start of the next odd line of
			; the image
	mov	bp,BANK_OFFSET-SCREEN_WIDTH+IMAGE_WIDTH
			;offset from the end of an odd line
			; of the image in display memory to
			; the start of the next even line of
			; the image
	mov	cx,IMAGE_HEIGHT/2
			;# of even/odd numbered row pairs to
			;  draw in the image
XorRowLoop:
	rept	IMAGE_WIDTH/2
	lodsw		;next word of the image pattern
	xor	es:[di],ax	;XOR the next word of the
				; image into the screen
	inc	di	;point to the next word in display
	inc	di	; memory
	endm
	add	di,dx	;point to the start of the next
			; (odd) row of the image, which is
			; in the second bank of display
			; memory
	rept	IMAGE_WIDTH/2
	lodsw		;next word of the image pattern
	xor	es:[di],ax	;XOR the next word of the
				; image into the screen
	inc	di	;point to the next word in display
	inc	di	; memory
	endm
	sub	di,bp	;point to the start of the next
			; (even) row of the image, which is
			; in the first bank of display
			; memory
	loop	XorRowLoop	;count down the row pairs
	ret
