#include <stdio.h>
#include "mconf.h"
#include "prec.h"
#include "ssystem.h"


/* rdnums.c
 */

static FILE *in;
char *fgets();

struct number
	{
	DOUBLE *val;
	int n;
	};
extern DOUBLE JD0, JD1, C, EMRAT, KG, AU, RADS, RADM, RADE, AE, AM;
extern DOUBLE K2M, LOVENO, PHASE, PSLP1, PSLPI, PSLPIA, PSLPIB;
extern DOUBLE JDEPOCH, LBET, LGAM, LGAMBET;
extern DOUBLE CMRSQ, CMR2, BMR2, AMR2;
extern DOUBLE yn0[], yn1[], GMs[], Je[], Jm[], Cnm[], Snm[];

struct number nums[] = {
{&JD0, 1},
{yn0, 72},
{&JD1, 1},
{yn1, 72},
{&C, 1},
{&EMRAT, 1},
{&KG, 1},
{GMs, 17},
{&AU, 1},
{&RADS, 1},
{&RADM, 1},
{&RADE, 1},
{&AE, 1},
{Je, 3},
{&AM, 1},
{Jm,3},
{Cnm, 8},
{Snm, 8},
{&K2M, 1},
{&LOVENO, 1},
{&PHASE, 1},
{&PSLP1, 1},
{&PSLPI, 1},
{&PSLPIA, 1},
{&PSLPIB, 1},
{&JDEPOCH, 1},
{&LBET, 1},
{&LGAM, 1},
{&LGAMBET, 1},
{&CMRSQ, 1},
{&CMR2, 1},
{&BMR2, 1},
{&AMR2, 1},
{NULL, 0}
};

rdnums()
{
char str[128];
#if LDOUBLE
long double x;
long double *px;
#else
double x;
double *px;
#endif
struct number *pnum;
int i, n;

printf( "Reading in physical parameters...\n" );
in = fopen( "aconst.h", "r" );
if( in == NULL )
	{
	printf( "can't find aconst.h\n" );
	exit(0);
	}

pnum = nums;

inloop:
px = pnum->val;
n = pnum->n;
if( n <= 0 )
	goto done;
for( i=0; i<n; i++ )
	{
nxtline:
	if( fgets( str, 80, in ) == NULL )
		{
		printf( "aconst.h file i/o error\n" );
		exit(0);
		}
	if( str[0] == ';' )
		goto nxtline;
#if LDOUBLE
	asctoe64( str, &x );
#else
	asctoe53( str, &x );
#endif
	if( *px != x )
		{
#if LDOUBLE
		e64toasc( px, str, 25 );
		printf( "%s changed to ", str );
		e64toasc( &x, str, 25 );
		printf( "%s\n", str );
#else
		e53toasc( px, str, 18 );
		printf( "%s changed to ", str );
		e53toasc( &x, str, 18 );
		printf( "%s\n", str );
#endif
		*px = x;
		}
	++px;
	}
++pnum;
goto inloop;
done:
fclose(in);
}
