/*
   Module:  parse.h
   Date:    3/9/92
   Version: 1.0b
   Author:  Dave Lutz
   Email:   lutz@psych.rochester.edu
   Copyright: 1992 University of Rochester, Psychology Dept.

   Disclaimer:  This software is distributed free of charge.  As such, it
                comes with ABSOLUTELY NO WARRANTY.  The user of the software
                assumes ALL RISKS associated with its use.

                Your rights to modify and/or distribute this software are
                outlined in the file ADI7221.DOC.

   Purpose: This module provides the function prototype for the function 
            needed to parse the lines from an ADI file, breaking the line 
            into a command and its arguments.

   Functions Provided:

        parse

*/




/*
   Function: parse
   Purpose:  Parse a line from an ADI file, converting it to a command and
             its arguments.

   Pre: line is a pointer to a line from an ADI file.
        cmd is a pointer to storage for the ADI command.
        arg1 is a pointer to storage for the first argument to the command
        (if it has an argument)
        arg2 is a pointer to storage for the second argument to the command
        (if it has two arguments)

   Post: An attempt is made to decode line.
         The ADI command found in line is copied to cmd.
         If the command has an argument it is copied to arg1.
         If the command has two arguments, the second is copied to arg2.
         If an error occurs, NOCMD is copied to cmd.
         If arg1 and/or arg2 are not required for a command, their contents
         are undefined.
*/


void parse (char *line, int *cmd, unsigned *arg1, unsigned *arg2);
