                     /*********************/
                     /* Program ASK_BAT.C */
                     /*********************/

/* Copyright 1989 Floyd D. Pretz Sr.
 *                5834 Spaulding St.
 *                Omaha, NE  68104
 *
 * Purpose: To parse Console input within a batch file and return with
 *          with an appropriate DOS ERRORLEVEL, and/or echo text to the
 *          console with cursor control.
 *
 * Input:  DOS command line parameters.
 *
 * Output: Modified ERRORLEVEL for batch testing.
 *
 * Description: ask_bat was written with the intention of providing
 *              a method to pause for a few seconds within a batch
 *              file (especially autoexec) to get an option from
 *              the operator that would determine the next action
 *              that the batch file would perform.  If the operator
 *              was unavailable, some default option could be assumed
 *              then batch processing continued.
 *
 *  Use:  ask_bat [ 'string' errlev ... ] [ /T:nnn ] [ /H ] [ /F ] [ /P prompt ]
 *
 *        string - any character string to match from the keyboard.
 *        errlev - the ERRORLEVEL to exit with if preceding string selected.
 *        /T:nnn - maximum time to wait for keyboard activity.
 *            /H - hot key switch (On). attempt to match on one keystroke.
 *            /F - force match switch (On).  'string' must be matched.
 *            /P - prompt text follows.
 *        prompt - text to display prior to keyboard parsing.
 *
 *        Notes: - string-errlev pairs, if any, must occur first in the
 *                 parameter list.
 *               - parameters are space delimited.
 *               - switches may occur in any order following the string-errlev
 *                 pairs.
 *               - prompt or string parameters must be enclosed in double
 *                 quotes (") if either contains a space character.
*/

        #include <stdio.h>
        #include <stdlib.h>
        #include <time.h>
        #include <string.h>
        #include <stdlib.h>
        #include <conio.h>

        #define false 0
        #define true 1

        void main(int argc, char *argv[])

        {
        clock_t start, end, elapsed;            /* define timer variabls */
        char response[129];                     /* storage for keystroks */
        int timed, hotkey, forced;              /* logical flags         */
        int i, indx, lastpair;                  /* miscellaneous         */
        int maxtime, errlev, keys;              /* miscellaneous         */
        void ask_hlp();                         /* define usage routine  */
        void ask_hlp_big();                     /* define help routine   */

/*
 *                    
 *  Main Program Body 
 *                    
*/

/*
 *  Check for "?" parameter or absence of
 *  parameters and give appropriate help message.
*/
        if (argc==1) { ask_hlp();               /* if no command args */
                       i=getch();               /* print usage, get a */
                       exit(0);   }             /* keystroke & exit   */
        if (!stricmp("?",argv[1]))              /* if ? command arg   */
                     { ask_hlp_big();           /* print help & exit  */
                       exit(0);   }
/*
 *  Initialize local variables
*/
	response[0] = 0;
        start = clock();                        /* get initial time stamp */
        timed = hotkey = forced = false;        /* default options false */
        keys = 0;                               /* Keyboard buffer index */
        errlev=-1;                              /* -1 indicates no match */
        lastpair=argc;                          /* last string-errlev    */

/*
 * Process the command line by looping
 * through the argument list looking for 
 * switches and setting logic flags.
*/
        for (indx = 1; indx <= argc-1; indx++)
           {                                
            if (!strnicmp("/ ",argv[indx],1)) {        /* switch parameter?  */
               if (lastpair==argc) lastpair=indx-1;    /* set lastpair index */
               if (!stricmp("/H",argv[indx]))                 /* Hot Key ? */
                  hotkey=true;
               else if (!stricmp("/F",argv[indx]))            /* Forced  ? */
                  forced=true;
               else if (!strnicmp("/T:",argv[indx],3))        /* Timed   ? */
                  { timed=true;
                    maxtime=atoi(argv[indx]+3); }
               else if (!stricmp("/P",argv[indx]))            /* Prompt  ? */
                  { if (argc >= indx)
                       printf(argv[++indx]); }
               else
                  printf("Invalid switch '%s'\n",argv[indx]); /* ?????? ?  */
               }
           }
/*
 *  loop indefinitely until time exceeded while gathering keystrokes.
 *  continue looping until parameter list satisfied (errlev != -1).
*/

        do {
           if (!kbhit()) {                          /* Keystroke waiting?   */
              if (timed) {                          /* No keyboard activity */
                 end=clock();                       /* get & check time     */
                 elapsed=(end-start)/13;            /* CLK_TCK not used     */
                 if (elapsed > maxtime) {           /* Timeout!             */
                    errlev=0;
                    if (lastpair > 0) {             /* assume match on 1st  */
                       printf (argv[1]);            /* string-errlev pair   */
                       errlev=atoi(argv[2]);
                    }
                 }
              }
           }
/*
 *  Key Hit!   - Process non-ascii as a delete key.
 *             - Trap Hot keys
 *             - Buffer other keys
 *             - & reset clock
*/
           else {
              i=getch();
              if (!i || i==8) {                 /* if null/delete then  */
                 if (!i) i=getch();             /* process as delete    */
                 if (keys) {
                    --keys;                     /* backup string end    */
                    response[keys]=0;                                     
                    printf("\b \b");
                 }
              }
              else {
                 if (i != 13) {                 /* Buffer keystroke &  */
                    response[keys]=i;           /* display character   */
                    if (!hotkey) {              /* if not hot key mode */
                       keys++;
                       response[keys]=0;        /* string terminator   */
                       putchar(i);
                    }
                 }
/*
 *  Hotkey! or <RETURN> key!
*/  
                 if (hotkey||(i==13)) {
                    if (lastpair==0) errlev=0;
/*
 *  Loop through string-errlev pairs looking for a match
*/
                    for (indx = 1; indx < lastpair; indx=indx+2) {
/*
 *  Check hotkey
*/
                       if (hotkey && !strnicmp(response,argv[indx],1)) {
                          errlev=atoi(argv[indx+1]);
                          printf(argv[indx]); 
                       }
/*
 *  Check non-hotkey strings
*/
                       else if (!stricmp(response,argv[indx]))
                          errlev=atoi(argv[indx+1]);
                    }
/*
 *  Process a simple <RETURN> as a default
*/
                    if (!forced && errlev==-1) { 
                       if (i==13 && keys==0) {
                          printf(argv[1]);
                          errlev=atoi(argv[2]);
                       }
                    }
/*
 *  Bell (Beep) if no match or miss match
*/
                    if (errlev==-1) printf("\a");
                 }
              }
              start=clock(); }
/*
 *  End of keyboard processing loop
*/
           } while (errlev < 0 );
        printf("\n");
        exit(errlev);
        }

/*                                */
/*        subroutine ask_hlp      */
/*                                */

   void ask_hlp()
     {
     char *help;
     help =                                        /* assign help text */
     "Usage: ask_bat [ \"string\" errlev ... ]"
     " [ /T:nnn ] [ /H ] [ /F ] [ /P \"prompt\" ]\n\n"
     "       ask_bat ? (will display an extended help screen)\n\n"
     "Press any key to continue ...";
     printf("%s",help);
     }

/*                                */
/*        subroutine ask_hlp_big  */
/*                                */

        void ask_hlp_big()
        {
        char *help;
        help =                                        /* assign help text */
"       program: ask_bat\n"
"\n"
"       Copyright 1989 Floyd D. Pretz Sr.\n"
"                      5834 Spaulding St.\n"
"                      Omaha, NE  68104\n"
"\n"
"       Distribution of this program for non-commercial purposes\n"
"       is permitted.  Author assumes no liability for losses due to\n"
"       malfunction of this program.\n"
"\n"
"       Description:  The ask_bat program was designed to allow\n"
"                     for timed response to (Y/N) type prompts\n"
"                     in .BAT files - esp the Autoexec.bat file.\n"
"                     The program was written to satisfy a need\n"
"                     to recover from a system reboot of a BBS\n"
"                     (Bulletin Board System) following the loss\n"
"                     of modem carrier, and still allow the system\n"
"                     operator (if present) to answer typical\n"
"                     configuration 'boot' questions.  Using ask_bat\n"
"                     with timing options, the system will not wait\n"
"                     indefinitely for console response, but will assume\n"
"                     a default response after a specified period of\n"
"                     time.  This also allows you the opportunity to\n"
"                     go fill your coffee cup during the boot process\n"
"                     and not wait around to answer batch prompts.\n"
"\n"
     "Use: ask_bat [ \"string\" errlev ... ]"
     " [ /T:nnn ] [ /H ] [ /F ] [ /P \"prompt\" ]\n"
"\n"
"                where: 'string' is an optional keyboard (console)\n"
"                        response to which the program will exit with\n"
"                        an ERRORLEVEL set to errlev.  You can use as\n"
"                        many of the 'string'-errlev sets as you wish\n"
"                        (DOS command line can not exceed 128 characters).\n"
"                        The absence of any such pairs will function\n"
"                        as 'Press any key to continue' with the\n"
"                        errorlevel set to 0.  'string' is not case\n"
"                        sensitive (i.e.  'Yes', 'YES' & 'yEs' are\n"
"                        treated identically).\n"
"\n"
"                        /T:nnn is an option to time keyboard activity\n"
"                        and exit ask_bat after nnn seconds.  If the\n"
"                        /T parameter is not specified or nnn=0 then\n"
"                        keyboard activity is not timed and ask_bat will\n"
"                        wait indefinitely for console activity.  In the\n"
"                        case of a time out (user did not respond within\n"
"                        nnn seconds) the default is assumed to be the\n"
"                        first 'string'-errlev parameter (if any).\n"
"                        The default is also assumed if the console\n"
"                        response is null (Enter key only).\n"
"\n"
"                        /H is an option to enable a HOT KEY feature\n"
"                        which attempts to match a single keystroke\n"
"                        to one of the 'string' parameters and exit\n"
"                        accordingly.\n"
"\n\f"
"                         /F is an option to force the user to key in\n"
"                        one of the 'strings' in order to exit the program.\n"
"                        the program will 'beep' if an incorrect entry\n"
"                        is detected.\n"
"\n"
"                        /P prompt is an option to display a string on the\n"
"                        screen without forcing a <RETURN>.\n"
"\n"
"                        Invocation without any parameters will function\n"
"                        similar to the DOS PAUSE statement.\n"
"\n"
"             examples:        ask_bat yes 1 no 2 maybe 3 /T:15 /H\n"
"\n"
"                                 will exit with errorlevel=1 if the\n"
"                                 character 'Y' or 'y' is pressed or\n"
"                                 if 15 seconds elapses or only the\n"
"                                 <RETURN> key is pressed.  Also exits with\n"
"                                 errorlevel=2 if 'N' or 'n' is pressed\n"
"                                 and exits with errorlevel=3 if 'M' or\n"
"                                 'm' is pressed.\n"
"\n"
"                        ask_bat /H\n"
"\n"
"                                 Functions similar to the PAUSE command.\n"
"\n"
"                        ask_bat tom 10 dick 20 /F\n"
"\n"
"                                 Will exit with errorlevel=10 if 'TOM',\n"
"                                 'tom', 'Tom', etc is keyed in, or exit\n"
"                                 with errorlevel=20 if 'Dick', etc is keyed\n"
"                                 in. Because of the '/F' parameter one\n"
"                                 of these two responses must be keyed in\n"
"                                 in order for ask_bat to exit.\n"
"\n"
"                        ask_bat yes 3 no 2 /H /T:15 /P \"Continue --> \"\n"
"\n"
"                                 Will display the prompt string and then\n"
"                                 wait up to 15 seconds for a hot key.\n"
"\n"
"                        ask_bat ? > readme.txt\n"
"\n"
"                                 This will create the readme.txt file\n"
"                                 which you can later print. Or ...\n"
"\n"
"                        ask_bat ? | more\n"
"\n"
"                                 Which will force the screen to pause\n"
"                                 while you read the help text.\n";
        printf("%s",help);
        }

