; EchoSys : show current system data (drive, dir, time, date etc)
;           for redirection purposes
;
; Version 1.0
;
; Free Software by TapirSoft Gisbert W.Selke, Sept 1989
;
; This programme may be used and copied any way you wish, except don't
; sell it. Give credit where credit is due, please. - The copyright remains
; with me; I do not guarantee proper operation of this utility; the whole
; risk of use lies with the user.
;
; Usage:   echosys <string>
;          String is echoed to stdout; two-char sequences introduced by '^'
;          are replaced as indicated at 'Usage' below.
;
; TASM     echosys                  or        MASM   echosys
; TLINK /t echosys                            LINK   echosys
;                                             EXEBIN echosys.exe echosys.com

BackSpace       Equ     08h
LineFeed        Equ     0Ah
Return          Equ     0Dh
CtrlZ           Equ     1Ah


DisplayAL       Macro                           ; macro to echo the
                Mov     dl, al                  ; contents of AL to stdout
                Mov     ah, 02h
                Int     21h
                Endm

DisplayChar     Macro   Chr                     ; macro to echo a character
                Mov     dl, Chr                 ; character to stdout
                Mov     ah, 02h
                Int     21h
                Endm

Jmps            Macro   Label                   ; Jump short
                Jmp short Label
                Endm


cseg            Segment

                Org 0080h
Parameter       Db      ?

                Org 100h
                Assume CS:cseg, DS:cseg, ES:cseg

Start:          Jmp     Begin

                db      'SPECIAL='
Special         db      '^'

                db      Return
Copyright       db      'EchoSys 1.0 - Free software by TapirSoft'
                db      ' Gisbert W.Selke, Sept 89', Return, LineFeed
                db      'Use at your own risk.$', BackSpace, ' '
                db      Return, LineFeed, CtrlZ

Usage1          db      Return, LineFeed, LineFeed
                db      'Usage: echosys <string>', Return, LineFeed
                db      'The string is echoed to stdout with "$'
Usage2          db      '@" replaced as indicated by @:', Return, LineFeed
                db      ': drive; \ directory; F free disk space; '
                db      'T total disk space; R free RAM;', Return, LineFeed
                db      'r RAM size; l #drives; f #floppies; P #printers; '
                db      'S #serial ports;', Return, Linefeed
                db      '7 coprocessor? L LPT1 status; V video mode; '
                db      'w screen width; t type of PC;', Return, LineFeed
                db      'v DOS version; b BIOS version; i "<" symbol; '
                db      'o ">" symbol; p "|" symbol; ', Return, LineFeed
                db      'O switch char; A author''s note; '
                db      'x char given by next 2 hex digits;', Return, LineFeed
                db      'K key typed by user; C country code; $'
Usage3          db      ' currency string;', Return, LineFeed
                db      'k 1000s separator; 1 decimal separator; '
                db      '/ date separator; - time separator;'
                db      Return, LineFeed
                db      'D day; M month; Y year; W weekday; h hour; m minute; '
                db      's second; c centisecond.'
                db      Return, LineFeed, Return, LineFeed, '$'

RetVal          db      0

ModelString     db      '??80AP30??ATJRXTPC'
ModelStrLen     Label   Byte

CmdLetters      db      'csmhWYMD-/1k$CpoiKxAObvtwVL7SPflRrTF\:';command letters
EndCmdLetters   Label   Word

; **NOTE**: order of CmdLetters and Dispatch is reversed w.r.t. each other!

Dispatch        dw      Drive, Directory, FreeSpace, TotalSpace, MemSize
                dw      FreeMem, LogicDrives, Floppies, Printers
                dw      CommPorts, Coproc, LptStat, VideoMode, VideoWidth
                dw      SysModel, DosVersion, BiosVersion, SwitchChar, Author
                dw      Hexnumber, KeyBoard
                dw      StdInSymbol, StdOutSymbol, PipeSymbol, CountryInfo
                dw      Currency, Thousands, Decimal, DateSep, TimeSep
                dw      Day, Month, Year, WeekDay
                dw      Hour, Minute, Second, CentiSecond


Begin:          Mov     sp, Offset OurStack     ; point to our own stack
                Mov     bx, Offset ProgEnd + 15 ; pointer to end of programme
                Mov     cl, 4                   ; convert size to paragraphs
                ShR     bx, cl
                Mov     ah, 4Ah                 ; return unused memory to DOS
                Int     21h

                Mov     ah, 2Ch                 ; get current time right now
                Int     21h
                Mov     [TimeBuf],   ch         ; stow away
                Mov     [TimeBuf+1], cl
                Mov     [TimeBuf+2], dh
                Mov     [TimeBuf+3], dl
                Mov     ah, 2Ah                 ; get current date
                Int     21h
                Sub     cx, 1900                ; remove centuries
                Mov     word ptr [DateBuf], cx  ; stow away
                Mov     [DateBuf+2], dh
                Mov     [DateBuf+3], dl
                Mov     [DateBuf+4], al

                Mov     si, 1+offset Parameter  ; command line string
                Lodsb
                Cmp     al, ' '                 ; skip first char, if
                Je      NextChar                ; blank or tab
                Cmp     al, 09h
                Je      NextChar
                Cmp     al, Return
                Jne     CheckSpecials
                Mov     dx, offset Copyright    ; show author's note
                Mov     ah, 09h
                Int     21h
                Mov     dx, offset Usage1       ; show usage hints
                Mov     ah, 09h
                Int     21h
                DisplayChar Special
                Mov     dx, offset Usage2       ; more usage hints
                Mov     ah, 09h
                Int     21h
                DisplayChar '$'
                Mov     dx, offset Usage3       ; more usage hints
                Mov     ah, 09h
                Int     21h
                Mov     [RetVal], 0FFh          ; termination code
                Jmps    Done

NextChar:       Lodsb
                Cmp     al, Return              ; are we done?
                Jne     CheckSpecials
Done:           Mov     ah, 4Ch                 ; terminate normally
                Mov     al, [RetVal]            ; return code
                Int     21h


CheckSpecials:  Cmp     al, Special             ; is it special sequence?
                Je      DoSpecials
CheckSp2:       DisplayAL                       ; otherwise just display it
                Jmps    NextChar                ; and loop

DoSpecials:     Lodsb                           ; get next char of sequence
                Mov     di, offset CmdLetters   ; look up in table
                Mov     cx, (offset EndCmdLetters) - (offset CmdLetters)
                Repne   Scasb
                Jz      DoSp2                   ; jump if found
                Cmp     al, Return              ; otherwise: are we done?
                Je      Done
                Jmps    CheckSp2                ; otherwise treat normal

DoSp2:          Add     cx, cx                  ; double for Word
                Mov     bx, cx
                Call    [dispatch+bx]           ; call the subroutine
                Jmps    NextChar


Drive:          Mov     ah, 19h                 ; get current drive
                Int     21h
                Add     al, 41h                 ; convert to ASCII
                Mov     [RetVal], al            ; store for return
                DisplayAL                       ; and show it
                DisplayChar ':'                 ; and a colon
                Ret


Directory:      Mov     cx, si                  ; save si
                Mov     si, offset DirString    ; buffer for dir string
                Xor     dl, dl                  ; use current drive
                Mov     ah, 47h                 ; get directory string
                Int     21h

                DisplayChar '\'                 ; initial backslash

ShowDirLoop:    Lodsb                           ; get next byte
                Or      al, al                  ; is it terminating null?
                Jz      ShowDirEnd
                mov     dl, al                  ; otherwise show char
                Int     21h                     ; (ah is ok!)
                Jmps    ShowDirLoop             ; and loop
ShowDirEnd:     Mov     si, cx                  ; restore si
                Ret


FreeSpace:      Mov     ah, 36h                 ; get disk space
                Xor     dl, dl                  ; on default disk
                Int     21h
                Jmps    ShowSpace


TotalSpace:     Mov     ah, 36h                 ; get disk space
                Xor     dl, dl                  ; on default disk
                Int     21h
                Mov     bx, dx                  ; choose total clusters
ShowSpace:      Mul     cx                      ; dx:ax = bytes per cluster
                Mov     cx, 10                  ; prepare conversion to kB
ShowSp2:        Or      dx, dx                  ; if dx > 0, shift it
                Jz      ShowSp3
                Inc     cl
                Shr     dx, 1
                Rcr     ax, 1
                Jmps    ShowSp2
ShowSp3:        Mul     bx                      ; multiply by clusters
ShowSp4:        Shr     dx, 1                   ; divide by 1024
                Rcr     ax, 1
                Loop    ShowSp4
                Mov     cx, 1000                ; process high digits first
                Div     cx
                Mov     [RetVal], al            ; save for return
                Mov     bx, dx                  ; save remainder
                Xor     dh, dh                  ; no minimum # of digits
                Or      ax, ax                  ; are there high digits?
                Jz      ShowSp5                 ; if not, skip
                Call    DisplayNumber           ; otherwise display
                Mov     dh, 3                   ; then minimum 3 digits
ShowSp5:        Mov     ax, bx                  ; retrieve low digits
                Jmp     DisplayNumber
                Ret


MemSize:        Int     12h                     ; get memory size
                Mov     [RetVal], ah            ; save for return
                Xor     dh, dh                  ; no minimum # of digits
                Jmp     Displaynumber


FreeMem:        Int     12h                     ; get total RAM size
                Mov     bx, es                  ; get start address of PSP
                Mov     cl, 6                   ; convert paras to KB
                Shr     bx, cl
                Sub     ax, bx                  ; subtract from total RAM
                Mov     [RetVal], ah            ; save for return
                Xor     dh, dh
                Jmp     DisplayNumber           ; presto: free RAM!


LogicDrives:    Mov     ah, 19h                 ; get number of logical drives
                Int     21h                     ; first, get current disk
                Mov     dl, al
                Mov     ah, 0Eh                 ; now get that number
                Int     21h
                Jmp     DisplayVeryShort


Floppies:       Int     11h                     ; number of floppies
                Test    al, 00000001b           ; is floppy installed?
                Jne     FloppiesFound           ; skip if so
                Xor     al, al                  ; otherwise set to 0
                Jmp     DisplayVeryShort

FloppiesFound:  Mov     cl, 6                   ; isolate number of floppies
                ShR     al, cl
                And     al, 0F3h
                Inc     al
                Jmp     DisplayVeryShort


Printers:       Int     11h                     ; number of printers
                Mov     cl, 14                  ; isolate number of printers
                ShR     ax, cl
                Jmp     DisplayVeryShort


CommPorts:      Int     11h                     ; number of comm ports
                Mov     cl, 9                   ; isolate number of ports
                ShR     ax, cl
                And     al, 7
                Jmp     DisplayVeryShort


Coproc:         Int     11h                     ; is coprocessor installed?
                ShR     al, 1                   ; output as 0 or 1
                And     al, 1
                Jmp     DisplayVeryShort


LptStat:        Mov     ah, 02h                 ; get printer status
                Xor     dx, dx                  ; printer port #0
                Int     17h
                Mov     al, ah
                Xor     dl, dl
                Jmp     DisplayShort


VideoMode:      Mov     ah, 0Fh                 ; get video mode
                Int     10h
                Xor     dh, dh
                Jmp     DisplayShort            ; display number


VideoWidth:     Mov     ah, 0Fh                 ; get screen width
                Int     10h
                Mov     al, ah                  ; width was in ah
                Xor     dh, dh
                Jmp     DisplayShort


SysModel:       Push    es                      ; get model indicator
                Mov     bx, 0F000h              ; save ES; set up ES to
                Mov     es, bx                  ; point to ROM location
                Mov     bl, byte ptr es:0FFFEh  ; this is model indicator
                Pop     es                      ; restore ES
                Sub     bl, 0F7h                ; subtract offset
                Mov     [RetVal], bl            ; save for return
                Shl     bl, 1
                Xor     bh, bh
                Cmp     bl, ModelStrLen - ModelString
                Jbe     SysModel2
                Xor     bl, bl
SysModel2:      DisplayChar [ModelString+bx]    ; display ID
                DisplayChar [(ModelString+1)+bx]
                Ret


DosVersion:     Mov     ah, 30h                 ; get DOS version
                Int     21h
                Push    ax
                Call    DisplayVeryShort        ; show major version number
                DisplayChar '.'
                Pop     ax
                Xchg    ah, al                  ; and minor version number, too
                Jmp     DisplayTwoDigs


BiosVersion:    Push    ds                      ; get BIOS version; save DS
                Push    si                      ; ... and SI
                Mov     ax, 0FFFFh              ; set up DS
                Mov     ds, ax                  ; to point to ROM location
                Mov     si, 5h
                Mov     cx, 8                   ; 8 bytes length
                Mov     ah, 02h
BiosVer2:       Lodsb
                Mov     dl, al                  ; display char
                Int     21h
                Loop    BiosVer2                ; loop for 8 chars
                Pop     si                      ; restore SI...
                Pop     ds                      ; and DS
                Ret


SwitchChar:     Mov     ax, 3700h               ; get switch character
                Int     21h
                Mov     [RetVal], dl            ; save for return
                Mov     ah, 02h
                Int     21h
                Ret


Author:         Mov     dx, offset Copyright    ; show author's note
                Mov     ah, 09h
                Int     21h
                Ret


KeyBoard:       Xor     ah, ah                  ; get key from user
                Int     16h
                Or      al, al                  ; was it extended key?
                Je      KeyBoard                ; if so, try again
                Mov     [RetVal], al            ; save for return
                DisplayAL                       ; otherwise echo
                Ret


StdInSymbol:    DisplayChar '<'                 ; display stdin redir.symbol
                Mov     [RetVal], '<'           ; save for return
                Ret


StdOutSymbol:   DisplayChar '>'                 ; display stdout redir.symbol
                Mov     [RetVal], '>'           ; save for return
                Ret


PipeSymbol:     DisplayChar '|'                 ; display pipe symbol
                Mov     [RetVal], '|'           ; save for return
                Ret


HexNumber:      Lodsb                           ; display byte given by
                Cmp     al, Return              ; two hex digits
                Je      HexEnd
                Sub     al, '0'                 ; subtract ASCII offset
                Cmp     al, 9                   ; was that enough?
                Jbe     Digit1OK                ; if so, skip
                Sub     al, 7                   ; subtract rest
                Cmp     al, 0Fh                 ; was that enough?
                Jbe     Digit1OK                ; if so, skip
                Sub     al, 'a'-'A'             ; otherwise assume lower-case

Digit1OK:       Mov     cl, 4                   ; shift as appropriate
                ShL     al, cl
                Mov     dl, al
                Lodsb                           ; get second digit
                Cmp     al, Return
                Je      HexEnd
                Sub     al, '0'                 ; subtract ASCII offset
                Cmp     al, 9                   ; was that enough?
                Jbe     Digit2OK                ; if so, skip
                Sub     al, 7                   ; subtract rest
                Cmp     al, 0Fh                 ; was that enough?
                Jbe     Digit2OK                ; if so, skip
                Sub     al, 'a'-'A'             ; otherwise assume lower-case

Digit2OK:       Or      dl, al                  ; combine digits
                Mov     [RetVal], dl            ; save for return
                Mov     ah, 02h                 ; and put 'em out
                Int     21h
                Ret

HexEnd:         Pop     ax                      ; premature end; pop address
                Jmp     Done


CountryInfo:    Mov     ax, 3800h               ; get country info
                Mov     dx, offset DirString
                Int     21h
                Mov     al, bl
                Jmps    DisplayVeryShort        ; show it


Currency:       Mov     ax, 3800h               ; get country info
                Mov     dx, offset DirString
                Int     21h
                Mov     ah, [DirString+2]
                Mov     [RetVal], ah            ; save for return
                Mov     ah, 02h                 ; prepare to output ASCIZ
                Xor     bx, bx
Curr2:          Mov     dl, [(DirString+2)+bx]
                Or      dl, dl
                Je      Curr3
                Int     21h
                Inc     bx
                Jmps    Curr2
Curr3:          Ret


Thousands:      Mov     cx, 7                   ; prepare to get 1000 sep.
                Jmps    GetCountry


Decimal:        Mov     cx, 9                   ; prepare to decimal sep.
                Jmps    GetCountry


DateSep:        Mov     cx, 11                  ; prepare to date separator
                Jmps    GetCountry


TimeSep:        Mov     cx, 13                  ; prepare to time separator
GetCountry:     Mov     ax, 3800h               ; get country info
                Mov     dx, offset DirString    ; pointer to buffer
                Int     21h
                Mov     bx, cx
                Mov     al, [DirString+bx]      ; save for return
                Mov     [RetVal], al            ; save for return
                DisplayAL
                Ret


Day:            Mov     al, [DateBuf+3]         ; get day
                Jmps    DisplayTwoDigs


Month:          Mov     al, [DateBuf+2]         ; get month
                Jmps    DisplayTwoDigs


Year:           Mov     ax, word ptr [DateBuf]  ; get year
                Jmps    DisplayTwoDigs


WeekDay:        Mov     al, [DateBuf+4]         ; get weekday
                Jmps    DisplayVeryShort


Hour:           Mov     al, [TimeBuf]           ; get hours
                Jmps    DisplayTwoDigs


Minute:         Mov     al, [TimeBuf+1]         ; get minutes
                Jmps    DisplayTwoDigs


Second:         Mov     al, [TimeBuf+2]         ; get seconds
                Jmps    DisplayTwoDigs


CentiSecond:    Mov     al, [TimeBuf+3]         ; get centiseconds

DisplayVeryShort: Xor   dh, dh                  ; short number, no min digits
                Jmps    DisplayShort
DisplayTwoDigs: Mov     dh, 02                  ; display >= 2 digits
DisplayShort:   Xor     ah, ah                  ; output number up to 255
                Mov     [RetVal], al            ; save for return
DisplayNumber:  Xor     cx, cx                  ; output number up to 2559
                                                ; dh  is min # of digits
                Mov     dl, 10                  ; divisor
DispNum2:       Div     dl
                Push    ax                      ; one digit
                Inc     cl
                Xor     ah, ah
                Or      al, al
                Jnz     DispNum2                ; loop until we are done

                Cmp     cl, dh                  ; do we have enough digits?
                Jae     DispNum3                ; if so, skip
                Push    cx
                Sub     dh, cl
                Mov     cl, dh
DispNum2a:      DisplayChar '0'                 ; otherwise output leading 0s
                Loop    DispNum2a
                Pop     cx

DispNum3:       Pop     dx                      ; get back one digit
                Xchg    dh, dl
                Or      dl, '0'                 ; convert to ASCII
                Mov     ah, 02h                 ; and display
                Int     21h
                Loop    DispNum3

                Ret


DirString       db      64 dup (?)              ; buffer for directory name etc.
TimeBuf         db      4  dup (?)              ; buffer for current time
DateBuf         db      5  dup (?)              ; buffer for current date
                db      64 dup (?)              ; stack area
OurStack        Label   byte

ProgEnd         Label   byte

cseg            ends
end start
