/* kmenu.c */

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <dos.h>
#include "keys.h"
#include "twindow.h"

extern int VSG;

extern void pascal dcls(void);
extern void pascal dputc(int x, int y, int c);
extern int  pascal dputs(int x, int y, char *s);
extern void pascal dclrwnd(int x1, int y1, int x2, int y2);
extern void pascal dscrollup(int x1, int y1, int x2, int y2);
extern void pascal dscrolldn(int x1, int y1, int x2, int y2);

extern void (*helpfunc)();

extern unsigned int vbase;
extern unsigned int maxx;
extern unsigned int maxy;
extern unsigned char current_color;
extern unsigned char usemouse;
extern unsigned int videomethod;

WINDOW * pascal open_menu(char *mnm,KMENU *mn,int hsel);
int pascal gethmenu(KMENU *mn,WINDOW *hmenu,int hsel);
int pascal getvmn(KMENU *mn,WINDOW *hmenu,int *hsel,int vsel);
int pascal haccent(KMENU *mn,WINDOW *hmenu,int hsel,int vsel);
void pascal dimension(char *sl[],int *ht,int *wd);
void pascal light(KMENU *mn,WINDOW *hmenu,int hsel,int d);
#ifdef USECLOCK
 void pascal print_clock(void);
#endif


/* Display & process a menu */
int pascal kmenu_select(char *name,KMENU *mn) {

	WINDOW *hmenu;
	int sx,sy;
	int hsel=1,vsel;

    curr_cursor(&sx,&sy);
	cursor(0,26);
	hmenu=open_menu(name,mn,hsel);
	while(hsel=gethmenu(mn,hmenu,hsel)) {
		vsel=1;
		while(vsel=getvmn(mn,hmenu,&hsel,vsel)) {
			if(vsel>25) {
				vsel=1;
				continue;
			}
			delete_window(hmenu);
			set_help("",0,0);
			cursor(sx,sy);
            return (mn+hsel-1)->returnkey[vsel-1];
		}
	}
	delete_window(hmenu);
	set_help("",0,0);
	cursor(sx,sy);
    return 0;
}


/* Open a horizontal menu */
static WINDOW * pascal open_menu(char *mnm,KMENU *mn,int hsel) {

	int i=0;
	WINDOW *hmenu;

	set_help("kmenu     ",30,10);
	hmenu=establish_window(0,0,3,80);
	set_border(hmenu,6);
	set_title(hmenu,mnm);
	set_colors(hmenu,ALL,BLUE,AQUA,BRIGHT);
	set_colors(hmenu,ACCENT,WHITE,BLACK,DIM);
	display_window(hmenu);
    while((mn+i)->mname) {
        wcursor(hmenu,(i)*11+2,0);
        wprintf(hmenu,"%-9.9s",(mn+i++)->mname);
    }
	light(mn,hmenu,hsel,1);
	cursor(0,26);
	return hmenu;
}

/* Get a horizontal selection */
static int pascal gethmenu(KMENU *mn,WINDOW *hmenu,int hsel) {

	int sel;
	WINDOW *wnd;

	light(mn,hmenu,hsel,1);
	wnd=hmenu;
	SHOWMOUSE;
	CONFINEMOUSE(wnd);
	while(TRUE) {
		while(!kbhit()) {
		  if(usemouse) {

                union REGS rg;

                rg.x.ax=3;
                int86(0x33,&rg,&rg);
                move_mouse(rg.x.cx/8,rg.x.dx/8);
                rg.x.ax=5;
                rg.x.bx=0;          /* Check left button */
                int86(0x33,&rg,&rg);
				if(rg.x.bx) {       /* Button pressed */
                    rg.x.cx/=8;     /* Mouse x */
                    rg.x.dx/=8;     /* Mouse y */
					if(rg.x.cx==COL && rg.x.dx==ROW) {
						HIDEMOUSE;
						return 0;
					}
					if(rg.x.cx>COL && rg.x.dx>ROW && rg.x.cx<((COL+WIDTH)-1) && rg.x.dx<((ROW+HEIGHT)-1)) {
						rg.x.dx=rg.x.cx-COL;    /* rg.x.dx = window x pos of mouse */
						rg.x.cx=0;
						while((mn+rg.x.cx)->mname) {
							if(rg.x.dx>=(rg.x.cx*11+2) && rg.x.dx<=(rg.x.cx*11+2)+11) {
								HIDEMOUSE;
								light(mn,hmenu,hsel,0);
								light(mn,hmenu,rg.x.cx+1,1);
								return rg.x.cx+1;
							}
							rg.x.cx++;
						}
					}
				}
                rg.x.ax=3;
                int86(0x33,&rg,&rg);
                move_mouse(rg.x.cx/8,rg.x.dx/8);
                rg.x.ax=5;
				rg.x.bx=1;
				int86(0x33,&rg,&rg);
				if(rg.x.bx) {
					HIDEMOUSE;
					return 0;
				}
			  }
#ifdef USECLOCK
			  print_clock();
#endif
		}
		HIDEMOUSE;
		switch(sel=get_char()) {
			case FWD:
			case BS:	hsel=haccent(mn,hmenu,hsel,sel);
						break;
			case ESC:	return 0;
			case '\r': 	return hsel;
            case DN:    return hsel;
			default:	putchar (BELL);
						break;
		}
	}
}

/* Pop down a vertical menu */
static int pascal getvmn(KMENU *mn,WINDOW *hmenu,int *hsel,int vsel) {

	WINDOW *vmenu;
	int ht=10,wd=20;
	int temp;
	char **mp;

	while (1) {
		dimension((mn+*hsel-1)->mselcs,&ht,&wd);
		if(wd+(2+(*hsel-1)*11)>78)temp=79-wd;
		else temp=2+(*hsel-1)*11;
		vmenu=establish_window(temp,2,ht,wd);
		set_colors(vmenu,ALL,BLUE,AQUA,BRIGHT);
		set_colors(vmenu,ACCENT,WHITE,BLACK,DIM);
		set_border(vmenu,4);
		display_window(vmenu);
		mp=(mn+*hsel-1)->mselcs;
		while(*mp) wprintf(vmenu,"\n%s",*mp++);
		vsel=get_selection(vmenu,vsel,"");
		delete_window(vmenu);
		if(vsel==PGUP) vsel=FWD;
		if(vsel==PGDN) vsel=BS;
		if (vsel==FWD || vsel==BS) {
			*hsel=haccent(mn,hmenu,*hsel,vsel);
			vsel=1;
		}
		else
			return vsel;
	}
}

/* Manage the horizontal menu selection accent */
static int pascal haccent(KMENU *mn,WINDOW *hmenu,int hsel,int sel) {

	switch (sel) {
        case FWD:
			light(mn,hmenu,hsel,0);
			if((mn+hsel)->mname) hsel++;
			else hsel=1;
			light(mn,hmenu,hsel,1);
			break;
		case BS:
			light(mn,hmenu,hsel,0);
			if(hsel==1)	while((mn+hsel)->mname)	hsel++;
			else --hsel;
			light(mn,hmenu,hsel,1);
			break;
		default:
			break;
	}
	return hsel;
}

/* Compute a menu's height & width */
static void pascal dimension(char *sl[],int *ht,int *wd) {

    unsigned strlen(char *);

	*ht=*wd=0;
	while(sl[*ht]) {
		*wd=max(*wd,strlen(sl[*ht]));
		(*ht)++;
	}
	*ht+=2;
	*wd+=2;
}

/* Accent a horizontal menu selection */
static void pascal light (KMENU *mn,WINDOW *hmenu,int hsel,int d) {

    if(d) reverse_video(hmenu);
	wcursor(hmenu,(hsel-1)*11+2,0);
	wprintf(hmenu,(mn+hsel-1)->mname);
	normal_video(hmenu);
	cursor(0,26);
}


/*

int pascal hkmenu (char **selcs, char *keys, int *start) {

	int ky;
    int pos[40];
	int register x,ps;
	int last;
	char temp;

    if(!selcs) return 0;
	temp=current_color;
	current_color=BLACK + (WHITE * 16);
	x=0;
	last=1;
    while (x<40 && selcs[x]) {
		pos[x]=last;
		last+=dprintf(pos[x],maxy," %s ",selcs[x]);
        x++;
    }
	if(*start>x-1) *start=0;
	current_color=WHITE + (BLACK * 16);
	ps=*start;
	dprintf(pos[*start],maxy," %s ",selcs[ps]);
    while(TRUE) {
        ky=toupper(get_char());
        switch(ky) {
            case '\r':  ky=keys[ps];
                        goto BreakOut;
			case FWD:
			case BS:
						current_color=BLACK + (WHITE * 16);
						dprintf(pos[ps],maxy," %s ",selcs[ps]);
                        if(ky==FWD) {
                            ps++;
                            if(ps>=x) ps=0;
                        }
                        else {
                            ps--;
                            if(ps<0) ps=x-1;
                        }
						current_color=WHITE + (BLACK * 16);
						dprintf(pos[ps],maxy," %s ",selcs[ps]);
                        break;
            default:    goto BreakOut;
        }
    }
BreakOut:
	current_color=temp;
	*start=ps;
    return ky;
}

*/
