#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*         Kinetic constants         */
/*            dialog box             */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwsim.h"						/* macros, function prototypes, etc.	*/
#include "gep2.h"						/* gepasi's variables					*/
#include "simgvar.h"					/* global variables						*/
#include "strtbl.h"						/* symbols for the string table			*/

#pragma alloc_text( CODE2, AddReactLst, EdKConst)

void AddReactLst( HWND hControl, int j, int is_index, int scroll )
{
 WORD buffWidth;
 HANDLE hDC;

 hDC = GetDC( hControl );
 buffWidth = 5 + LOWORD( GetTextExtent( hDC, stepstr[j], _fstrlen(stepstr[j]) ) );
 SetTextJustification( hDC, 0, 0 );
 ReleaseDC( hControl, hDC );
 if( buffWidth > lbWidth )
 {
  lbWidth = buffWidth;
  SendMessage( hControl, LB_SETHORIZONTALEXTENT, lbWidth, (DWORD) 0 );
 }
 if( is_index )
 {
  SendMessage( hControl, LB_DELETESTRING, j, 0 );
  SendMessage( hControl, LB_INSERTSTRING, j, (DWORD) (LPSTR) stepstr[j] );
 }
 else
  SendMessage( hControl, LB_INSERTSTRING, -1, (DWORD) (LPSTR) stepstr[j] );
 if( scroll ) SendMessage( hControl, WM_VSCROLL, SB_BOTTOM, 0 );
}


BOOL FAR PASCAL EdKConst(HWND hDlg, WORD Message, WORD wParam, LONG lParam)
{
 static int first, last, lots, i, j, k, r;
 static BOOL circle;
 int len;
 static HWND hCtrl, hReactLst, hMore, hKineType, hStepName;
 char buff[128];
 LPSTR auxptr;

 switch(Message)
 {
  case WM_INITDIALOG:
   /* set the width of the list box to 0		*/
   lbWidth = 0;

   /* allocate memory for the mirror			*/
   hPrm = GlobalAlloc( GMEM_MOVEABLE | GMEM_ZEROINIT, sizeparam );
   if( hPrm == NULL )
   {
    LoadString(hInst, IDS_ERR_NOEXEC, szString, sizeof(szString));
    MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
    EndDialog(hDlg, FALSE);
    return TRUE;
   }
   /* the parameters of the first step are the first		*/
   prm[0] = (double huge *) GlobalLock( hPrm );

   /* set the other pointers								*/
   for( i=1; i<nsteps; i++ )
    prm[i] = prm[i-1] + ktype[kinetu[i-1]].nconst;

   /* copy params to its mirror									*/
   _fmemcpy( (void __far *) prm[0],
             (void __far *) params[0],
		     (size_t) sizeparam );

   /* get handles to controls					*/
   hReactLst = GetDlgItem( hDlg, IDC_REACTLST );
   hMore = GetDlgItem( hDlg, ID_MORE );
   hKineType = GetDlgItem( hDlg, IDC_KINETYPE );
   hStepName = GetDlgItem( hDlg, IDC_REACT );

   /* initialize hReactLst: add all reactions	*/
   for( i=0; i<nsteps; i++ )
    AddReactLst( hReactLst, i, 1, 0 );

   /* select the first reaction of hReactLst  */
   r = 0;
   SendMessage( hReactLst, LB_SETCURSEL, (WORD) r, 0 );

  case WM_USER+1:
   /* write the kinetic type description on the wide help button*/
   SendMessage( hKineType, WM_SETTEXT, 0, (DWORD)(LPSTR) ktype[kinetu[r]].descr );

   /* write this step's name on the edit box above the list box	*/
   SendMessage( hStepName, WM_SETTEXT, 0, (DWORD)(LPSTR) stepname[r] );

   /* initialize working variables								*/
   if (ktype[kinetu[r]].nconst >= 8 ) last = 8;
   else last = ktype[kinetu[r]].nconst;
   if ( ktype[kinetu[r]].nconst > 8 )  lots = TRUE;
   else lots = FALSE;
   first = 0;
   circle = FALSE;

   /* initialize static controls with constant names			*/
   for( j=first, i=IDT_M0; j<last; j++, i++ )
   {
    for( k=0, auxptr=ktype[kinetu[r]].constnam; k<j; k++ )
    {
     do{ auxptr++; } while( (*auxptr) );
     auxptr++;
    }
    SetDlgItemText( hDlg, i, (LPSTR) auxptr);
   }

   /* update edit boxes with constant's values					*/
   for( j=first, i=IDE_M0; j<last; j++, i++ )
   {
    gcvt( *(prm[r]+j), 16, buff );
    SetDlgItemText( hDlg, i, (LPSTR) buff);
   }

   /* show from first to last	 (static and edit controls)		*/
   for( j=first, i=IDT_M0, k=IDE_M0; j<last; j++, i++, k++ )
   {
    hCtrl = GetDlgItem( hDlg, k );
    ShowWindow( hCtrl, SW_SHOW );
    hCtrl = GetDlgItem( hDlg, i );
    ShowWindow( hCtrl, SW_SHOW );
   }
   /* hide from last to 9										*/
   for( ; k<=IDE_M7; i++, k++ )
   {
    hCtrl = GetDlgItem( hDlg, k );
    ShowWindow( hCtrl, SW_HIDE );
    hCtrl = GetDlgItem( hDlg, i );
    ShowWindow( hCtrl, SW_HIDE );
   }

   /* show MORE if more than 8 metabolites						*/
   if (lots) ShowWindow( hMore, SW_SHOW );
   else      ShowWindow( hMore, SW_HIDE );
   break;

  case WM_COMMAND:
   switch(wParam)
   {
    case IDC_REACTLST:
     if( HIWORD( lParam ) == LBN_SELCHANGE )
     {
	  /* get the constants from the edit boxes					*/
      for( i=IDE_M0, j=first; j<last; i++, j++)
      {
       hCtrl = GetDlgItem( hDlg, i);
       len = (int) SendMessage( hCtrl, WM_GETTEXT, (WORD) sizeof(buff), (DWORD) (LPSTR) buff );
       if( len==0 ) *(prm[r]+j) = dft_const;
       else *(prm[r]+j) = strtod( buff, NULL );
       if( (*(prm[r]+j)==HUGE_VAL) || (*(prm[r]+j)==-HUGE_VAL) )
       {
        LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
        MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
        SetFocus( hCtrl );
        return TRUE;
       }
      }
      r = (int) SendMessage( hReactLst, LB_GETCURSEL, 0, 0 );
      if( r != LB_ERR )
       SendMessage( hDlg, WM_USER+1, 0, 0 );
      break;
     }
     else return FALSE;

    case ID_MORE:
	 /* get the constants from the edit boxes					*/
     for( i=IDE_M0, j=first; j<last; i++, j++)
     {
      hCtrl = GetDlgItem( hDlg, i);
      len = (int) SendMessage( hCtrl, WM_GETTEXT, (WORD) sizeof(buff), (DWORD) (LPSTR) buff );
      if( len==0 ) *(prm[r]+j) = dft_const;
      else *(prm[r]+j) = strtod( buff, NULL );
      if( (*(prm[r]+j)==HUGE_VAL) || (*(prm[r]+j)==-HUGE_VAL) )
      {
       LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
       MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
       SetFocus( hCtrl );
       return TRUE;
      }
     }
     /* check need for going back to begginning				*/
	 if ( circle )
	 {
	  circle = FALSE;
	  SendMessage( hDlg, WM_USER+1, 0, (DWORD) 0 );
	  break;
	 }
     /* update working variables                            */
	 first = last;
     last += 8;
     if ( last >= (int) ktype[kinetu[r]].nconst )
     {
      last = ktype[kinetu[r]].nconst;
      circle = TRUE;
     }
     /* update static controls with constant names					*/
     for( j=first, i=IDT_M0; j<last; j++, i++ )
     {
      for( k=0, auxptr=ktype[kinetu[r]].constnam; k<j; k++ )
      {
       do{ auxptr++; } while( (*auxptr) );
       auxptr++;
      }
      SetDlgItemText( hDlg, i, (LPSTR) auxptr);
     }

     /* update edit boxes with constant's values					*/
     for( j=first, i=IDE_M0; j<last; j++, i++ )
     {
      gcvt( *(prm[r]+j), 16, buff );
      SetDlgItemText( hDlg, i, (LPSTR) buff);
     }
     /* show from first to last										*/
	 for( j=first, i=IDT_M0, k=IDE_M0; j<last; j++, i++, k++ )
     {
      hCtrl = GetDlgItem( hDlg, k );
      ShowWindow( hCtrl, SW_SHOW );
      hCtrl = GetDlgItem( hDlg, i );
      ShowWindow( hCtrl, SW_SHOW );
     }
     /* hide from last to 7											*/
     for( ; k<=IDE_M7; i++, k++ )
     {
      hCtrl = GetDlgItem( hDlg, k );
      ShowWindow( hCtrl, SW_HIDE );
      hCtrl = GetDlgItem( hDlg, i );
      ShowWindow( hCtrl, SW_HIDE );
     }
     break;

    case IDC_KINETYPE:        /* Help on this kinetic model				*/
     if( kinetu[r] < MAX_TYP )
   	  WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) ktype[kinetu[r]].descr );
   	 else
   	  WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "User-defined kinetics" );
     break;

    case IDC_HELP:            /* Help on this Dialog Box				*/
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Kinetic constants" );
     break;

    case IDOK:
	 /* get the constants from the edit boxes					*/
     for( i=IDE_M0, j=first; j<last; i++, j++)
     {
      hCtrl = GetDlgItem( hDlg, i);
      len = (int) SendMessage( hCtrl, WM_GETTEXT, (WORD) sizeof(buff), (DWORD) (LPSTR) buff );
      if( len==0 ) *(prm[r]+j) = dft_const;
      else *(prm[r]+j) = strtod( buff, NULL );
      if( (*(prm[r]+j)==HUGE_VAL) || (*(prm[r]+j)==-HUGE_VAL) )
      {
       LoadString(hInst, IDS_ERR_OVERFLOW, szString, sizeof(szString));
       MessageBox(hDlg, szString, NULL, MB_ICONEXCLAMATION);
       SetFocus( hCtrl );
       return TRUE;
      }
     }
	 /* copy params back from its mirror									*/
     _fmemcpy( (void __far *) params[0],
               (void __far *) prm[0],
		       (size_t) sizeparam );
     GlobalUnlock( hPrm );
     GlobalFree( hPrm );
	 notsaved = 1;
     EndDialog(hDlg, TRUE);
     break;

    case IDCANCEL:
     GlobalUnlock( hPrm );
     GlobalFree( hPrm );
     EndDialog(hDlg, FALSE);
     break;
   }
   break;    /* End of WM_COMMAND                                 */

  default:
   return FALSE;
 }
 return TRUE;
} /* End of METABMsgProc                                      */

