#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*               Units               */
/*            dialog box             */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <string.h>
#include <stdio.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwsim.h"						/* macros, function prototypes, etc.	*/
#include "gep2.h"						/* gepasi's variables					*/
#include "simgvar.h"					/* global variables						*/

#pragma alloc_text( CODE9, EdOUnits )

BOOL FAR PASCAL EdOUnits(HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
 static	HWND	hTime, hConc, hFlux, hStat;
 char buff[65], buff1[32], buff2[32];

 switch( message )
 {
  case WM_INITDIALOG:
   /* get handles to controls										*/
   hTime = GetDlgItem( hDlg, IDE_M0 );
   hConc = GetDlgItem( hDlg, IDE_M1 );
   hFlux = GetDlgItem( hDlg, IDE_M2 );
   hStat = GetDlgItem( hDlg, IDSTAT_3 );

   /* fill in the current set of options							*/
   SendMessage( hTime, WM_SETTEXT, 0, (DWORD)(LPSTR) options.timeu );
   SendMessage( hConc, WM_SETTEXT, 0, (DWORD)(LPSTR) options.concu );
   return TRUE;

  case WM_COMMAND:
   switch( wParam )
   {
    case IDE_M0:
    case IDE_M1:
     SendMessage( hConc, WM_GETTEXT, (WORD) sizeof( buff1 ), (DWORD)(LPSTR) buff1 );
     SendMessage( hTime, WM_GETTEXT, (WORD) sizeof( buff2 ), (DWORD)(LPSTR) buff2 );
     if( strchr( buff1, '/' )==NULL )
      wsprintf( (LPSTR) buff, "%s/%s", (LPSTR) buff1, (LPSTR) buff2 );
     else
      wsprintf( (LPSTR) buff, "%s.%s", (LPSTR) buff1, (LPSTR) buff2 );
     SendMessage( hFlux, WM_SETTEXT, 0, (DWORD)(LPSTR) buff );
     EnableWindow( hStat, FALSE );
     EnableWindow( hFlux, FALSE );
     InvalidateRect( hDlg, NULL, FALSE );
     return TRUE;

    case IDOK:
     /* read all variables from the controls		*/
     SendMessage( hTime, WM_GETTEXT, (WORD) sizeof( options.timeu ), (DWORD)(LPSTR) options.timeu );
     SendMessage( hConc, WM_GETTEXT, (WORD) sizeof( options.concu ), (DWORD)(LPSTR) options.concu );

     /* signal that changes were made				*/
     notsaved = 1;

     /* close the dialog box and return				*/
     EndDialog( hDlg, IDOK );
     return TRUE;

    case IDCANCEL:
     /* close the dialog box and return			*/
     EndDialog( hDlg, IDCANCEL );
     return TRUE;
   }

  default: return FALSE;
 }
}