#include "copyleft.h"

/*
    GEPASI - a simulator of metabolic pathways and other dynamical systems
    Copyright (C) 1989, 1992  Pedro Mendes
*/

/*************************************/
/*                                   */
/*         GWSIM - Simulation        */
/*        MS-WINDOWS front end       */
/*                                   */
/*           Report Options          */
/*             dialog box            */
/*                                   */
/*           QuickC/WIN 1.0          */
/*                                   */
/*   (include here compilers that    */
/*   compiled GWSIM successfully)    */
/*                                   */
/*************************************/


#include <windows.h>
#include <string.h>
#include "defines.h"					/* symbols also used in .DLG files		*/
#include "globals.h"					/* gepasi's own symbols					*/
#include "gwsim.h"						/* macros, function prototypes, etc.	*/
#include "gep2.h"						/* gepasi's variables					*/
#include "simgvar.h"					/* global variables						*/

#pragma alloc_text( CODE5, EdReport)

BOOL FAR PASCAL EdReport(HWND hDlg, WORD message, WORD wParam, LONG lParam)
{
 static HWND hStruct, hStab, hStdCC, hNonCC, hStdEla, hNonEla;

 switch( message )
 {
  case WM_INITDIALOG:
   /* get handles to the check boxes								*/
   hStruct = GetDlgItem( hDlg, IDC_STRUCT );
   hStab   = GetDlgItem( hDlg, IDC_STAB );
   hStdCC  = GetDlgItem( hDlg, IDC_MCA1 );
   hNonCC  = GetDlgItem( hDlg, IDC_MCA2 );
   hStdEla = GetDlgItem( hDlg, IDC_MCA3 );
   hNonEla = GetDlgItem( hDlg, IDC_MCA4 );

   /* fill in the current set of options							*/
   SendMessage( hStruct, BM_SETCHECK, (WORD) options.structan, 0 );
   SendMessage( hStab, BM_SETCHECK, (WORD) options.staban, 0 );
   SendMessage( hStdCC, BM_SETCHECK, (WORD) options.stdcc, 0 );
   SendMessage( hNonCC, BM_SETCHECK, (WORD) options.noncc, 0 );
   SendMessage( hStdEla, BM_SETCHECK, (WORD) options.stdela, 0 );
   SendMessage( hNonEla, BM_SETCHECK, (WORD) options.nonela, 0 );

   return TRUE;

  case WM_COMMAND:
   switch( wParam )
   {
    case IDC_HELP:            /* Help on this Dialog Box				*/
   	 WinHelp( hDlg, (LPSTR) szHelpFile, HELP_KEY, (DWORD) (LPSTR) "Report options" );
     break;

    case IDOK:
     /* read all variables from the controls		*/
     options.structan = (int) SendMessage( hStruct, BM_GETCHECK, 0, 0 );
     options.staban	  = (int) SendMessage( hStab, BM_GETCHECK, 0, 0 );
     options.stdcc	  = (int) SendMessage( hStdCC, BM_GETCHECK, 0, 0 );
     options.noncc	  = (int) SendMessage( hNonCC, BM_GETCHECK, 0, 0 );
     options.stdela	  = (int) SendMessage( hStdEla, BM_GETCHECK, 0, 0 );
     options.nonela	  = (int) SendMessage( hNonEla, BM_GETCHECK, 0, 0 );

     /* signal that changes were made				*/
     notsaved = 1;

     /* close the dialog box and return				*/
     EndDialog( hDlg, IDOK );
     return TRUE;

    case IDCANCEL:
     /* close the dialog box and return			*/
     EndDialog( hDlg, IDCANCEL );
     return TRUE;
   }

  default: return FALSE;
 }
}