PROGRAM Make_CFG;

(*

  Roger Link 12/08/89

*)

USES
  DOS, CRT;

CONST
  Black     = 0;     Blue      = 1;    Green     = 2;     Cyan      = 3;
  Red       = 4;     Magenta   = 5;    Brown     = 6;     L_Gray    = 7;
  Gray      = 8;     L_Blue    = 9;    L_Green   = 10;    L_Cyan    = 11;
  L_Red     = 12;    L_Magenta = 13;   Yellow    = 14;    White     = 15;

TYPE
  LineType = STRING[ 255 ];

VAR
  CFG_FileName : LineType;


(* As copied from page 96 of Turbo Pascal manual for old CP/M MS-DOS *)
(*  version (version 2.0 - 3.0??) *)
FUNCTION Exist( FileName : LineType ) : BOOLEAN;
VAR
  WorkFile : file;
BEGIN
  Assign( WorkFile, FileName );     (* Do a test to see if file exists *)
  {$I-}
  Reset( WorkFile );
  {$I+}

  Exist := (IOresult = 0 );
END; (* Exist *)


PROCEDURE Do_Signon;
BEGIN
  TextColor( Magenta );
  WriteLn( '** Link MakeCFG utility for use with SYSGEN - RAL 12/08/89 **' );
END;  (* Do_Signon *)


PROCEDURE Do_Help_Screen;
BEGIN
  TextColor( Green );
  WriteLn( 'MAKECFG filetype.typ' );
  WriteLn( '  Will create "filetype.typ" by merging \autoexec.bat and \config.sys' );
  WriteLn( '  and other files (the user is prompted for these "other" files) from ' );
  WriteLn( '  the current drive into a format ready for SYSGEN.' );
END;  (* Do_Help_Screen *)


PROCEDURE Do_MakeCFG( CFG_FileName : LineType );
VAR
  CFG_File   : TEXT;
  Input_File : TEXT;
  Line       : LineType;
  FileName   : LineType;
  Letter     : Char;

BEGIN
  Assign( CFG_File, CFG_FileName );
  ReWrite( CFG_File );

  TextColor( Green );
  WriteLn( ' Reading \autoexec.bat' );

  Assign( Input_File, '\autoexec.bat' );
  Reset( Input_File );

  WriteLn( CFG_File, '.;********************************************************' );
  WriteLn( CFG_File, '.;*'                                                        );
  WriteLn( CFG_File, '.;* SYSTEM.CFG created by MAKECFG from existing'              );
  WriteLn( CFG_File, '.;*    autoexec.bat & config.sys'                           );
  WriteLn( CFG_File, '.;*'                                                        );
  WriteLn( CFG_File, '.;********************************************************' );
  WriteLn( CFG_File, '.E SYSTEM.CFG - MAKECFG version'                              );
  WriteLn( CFG_File, '.;23456789'                                                 );
  WriteLn( CFG_File, 'E1        ** Default System Sysgen **'                      );
  WriteLn( CFG_File, 'V1        ** Default System Sysgen **'                      );
  WriteLn( CFG_File, 'F123456789\autoexec.bat'                                    );
  WriteLn( CFG_File, '-123456789@echo off'                                        );
  WriteLn( CFG_File, '-123456789rem ********************************************' );
  WriteLn( CFG_File, '-123456789rem * DO NOT EDIT THIS FILE. IT IS GENERATED'     );
  WriteLn( CFG_File, '-123456789rem *        BY MACHINE (SYSGEN.EXE)'             );
  WriteLn( CFG_File, '-123456789rem ********************************************' );
  WriteLn( CFG_File, '.;=========== Start of user AUTOEXEC.BAT' );

  WHILE NOT EOF( Input_File ) DO
    BEGIN
      ReadLn( Input_File, Line );
      WriteLn( CFG_File, '-1        ', Line );
    END;

  Close( Input_File );

  TextColor( Green );
  WriteLn( ' Reading \config.sys' );

  Assign( Input_File, '\config.sys' );
  Reset( Input_File );

  WriteLn( CFG_File, '.;*'                    );
  WriteLn( CFG_File, '.;*'                    );
  WriteLn( CFG_File, '.;* CONFIG.SYS stuff'   );
  WriteLn( CFG_File, '.;*'                    );
  WriteLn( CFG_File, '.;*'                    );
  WriteLn( CFG_File, '.;23456789'             );
  WriteLn( CFG_File, 'F123456789\config.sys'  );
  WriteLn( CFG_File, '.;=========== Start of user CONFIG.SYS' );

  WHILE NOT EOF( Input_File ) DO
    BEGIN
      ReadLn( Input_File, Line );
      WriteLn( CFG_File, '-1        ', Line );
    END;

  Close( Input_File );


  REPEAT
    REPEAT
      TextColor( Cyan );                        (* Grill user for Y/N *)
      Write( 'Include any other files Y/N? ' ); (*  response          *)
      TextColor( Brown );
      ReadLn( Letter );
      Letter := UpCase( Letter );
    UNTIL Letter IN [ 'Y', 'N' ];


    IF Letter = 'Y' THEN
     BEGIN                                      (* Get filename *)
      TextColor( Cyan );
      Write( 'Enter Drive:\Path\Filename.Type? ' );
      TextColor( Brown );
      ReadLn( FileName );

      IF Exist( FileName ) THEN              (* If good file then do work *)
       BEGIN

         TextColor( Green );
         WriteLn( ' Reading ', FileName );

         Assign( Input_File, FileName );
         Reset( Input_File );
         WriteLn( CFG_File, '.;*'                      );
         WriteLn( CFG_File, '.;* USER INCLUDED FILE'   );
         WriteLn( CFG_File, '.;* ADDED DURING MAKECFG' );
         WriteLn( CFG_File, '.;* ', FileName           );
         WriteLn( CFG_File, '.;*'                      );
         WriteLn( CFG_File, '.;23456789'               );
         WriteLn( CFG_File, 'F123456789', FileName    );
         WriteLn( CFG_File, '.;=========== Start of user ', FileName );

         WHILE NOT EOF( Input_File ) DO
          BEGIN
           ReadLn( Input_File, Line );
           WriteLn( CFG_File, '-1        ', Line );
          END;

         Close( Input_File );

         WriteLn;
       END
      ELSE
       BEGIN
         TextColor( Red );
         WriteLn( 'File I/O ERROR during open of ', FileName );
       END;
     END;

  UNTIL Letter = 'N';

  Close( CFG_File );

END;  (* Do_MakeCFG *)


BEGIN
  Do_Signon;

  IF ParamCount = 0 THEN
    Do_Help_Screen
  ELSE
    BEGIN
      TextColor( Green );
      CFG_FileName := ParamStr( 1 );
      Do_MakeCFG( CFG_FileName );
    END;
END.
