/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"
#include <ctype.h>

/***
 *  Function    :  stris_alnum
 *
 *  Description :  Tests if a string contains only alphanumerical characters or '_'.
 *
 *  Parameters  :  in   char   *string
 *
 *  Return      :  1 if string contains only alphanumerical characters or '_'.
 *                 0 otherwise
 *
 *  OS/Compiler :  All
 ***/

int stris_alnum( const char *string )

{
  for (; *string; string ++ )
      if ( ! isalnum(*string) && (*string != '_') ) return 0;

  return 1;
}
