/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#include "strings.h"
#include <stdlib.h>


/***
 *  Function    : strncpyb
 *
 *  Description :  Like strncpy but truncates trailing blanks and \n,
 *                 skip leading blanks and adds a '\0'.
 *
 *  Decisions   :
 *
 *  Parameters  :  out   char * target
 *	           in    char * source
 *                 in    int    length
 *
 *  Return code :  like strncpy
 *
 *  Side-effects:  Pad target string to length with '\0'.
 *
 *  OS/Compiler :  All
 ***/

char *strncpyb( char *target, const char *source, int length )

{ char *lastnonblank = target - 1, *ptr;
  int offs = 0;

  while ( *source++ == ' ' ) offs++; source--;
  length -= offs;

  for ( ptr = target; (length > 0) && *source; length-- )
      {
        if ( *source != ' ' && *source != '\n' )
           lastnonblank = ptr;
        *ptr++ = *source++;
      }

  memset( lastnonblank + 1, '\0', ptr - lastnonblank + length + offs );

  return target;
}


