@echo OFF
REM MemBlock - Examples CEnvi DOS program to walk through the list of
REM            allocated memory.  This uses interrupts through the interrup()
REM            function, and direct memory access using peekbuf().
ECHO The following is a walk-through of your allocated memory blocks:
cenvi %0.bat
GOTO CENVI_EXIT

#define  MCB_HEADER_SIZE   16
#define  ID_OFFSET         0
#define  MORE_TO_FOLLOW    'M'   // set if more MCB follow in chain
#define  LAST_MCB          'Z'   // if no more MCB in chain
#define  PSP_SEG_OFFSET    1
#define  SIZE_OFFSET       3
#define  ENVIRONMENT_SEG_OFFSET  0x2C

/*************************************************************/
/* Get access to the first memory block through undocumented */
/* DOS interrupt to get the DIB (Dos Information Block.      */
/*************************************************************/
reg.ah = 0x52           // Get DIB address in ES:BX
interrupt(0x21,reg)
// The actual first mcb (memory control block) address is 4 bytes below
// es:bx, or 16 bytes above the previous paragraph
segment = PeekWord(reg.es - 1,reg.bx+14)


/*************************************************************/
/* Loop through all MCB's, displaying information about them */
/*************************************************************/
count = 0
total = 0
do {
   printf("==========================================\n")
   id = peek(Address(segment,ID_OFFSET))
   printf("MCB number\t= %d\n",++count)
   printf("ID\t\t= %c\n",id)
   printf("MCB address\t= %04X:0000\n",segment)
   printf("Memory address\t= %04X:0000\n",MemorySeg = segment+1)
   printf("PSP address\t= %04X:0000\n",PspSeg = PeekWord(segment,PSP_SEG_OFFSET))
   size = PeekWord(segment,SIZE_OFFSET)
   printf("Size\t\t= %d paragraphs (%d bytes)\n",size,size*16)
   if ( 0 != PSPSeg ) {
      EnvironmentBlock = PeekWord(PspSeg,ENVIRONMENT_SEG_OFFSET)
      if EnvironmentBlock == MemorySeg
         ShowEnvironmentBlock(EnvironmentBlock)
   }
   // increment segment to point to the next MCB
   segment += size + 1
   total += size + 1
} while( id == MORE_TO_FOLLOW )


/***************/
/* SHOW TOTALS */
/***************/
printf("==========================================\n")
printf("Totals:\n")
printf("MCB Count\t= %d\n",count)
printf("Memory\t\t= %d paragraphs (%d bytes)\n",total,total*16)


/*****************************************/
/* FUNCTION TO DISPLAY ENVIRONMENT BLOCK */
/*****************************************/
ShowEnvironmentBlock(seg)
{
   printf("Environment block at %04X:0000\n",seg)
   for ( Offset = 0; 0 != peek(Address(seg,Offset)); Offset++ ) {
      EString = peek(Address(seg,Offset),1000)
      Offset += strlen(EString)
      printf(" %s\n",EString)
   }
   printf("Program: ")
   if ( 0x0001 == PeekWord(seg,++Offset) ) {
      // the full path and name of the calling program follows
      printf("%s\n",peek(Address(seg,Offset+2),1000))
   } else
      printf("Unknown\n")
}

/***********************************************/
/* UTILITY FUNCTIONS USED IN THE ABOVE PROGRAM */
/***********************************************/
PeekWord(segment,offset)
{
   return( peek(Address(segment,offset),UWORD16) );
}

:CENVI_EXIT
