@echo off
REM *******************************************************************
REM *** Sound - Sound a specified frequency for specified number of ***
REM ***         milliseconds (approximate).                         ***
REM *******************************************************************
CEnvi %0.bat %1 %2 %3
GOTO CENVI_EXIT

main(argc,argv)
{
   if ( argc != 3 || 0 == (frequency=atol(argv[1])) || 0 == (duration=atol(argv[2])) )
      Instructions();
   else
      sound(frequency,duration)
}

sound(frequency,duration)  // frequency is in Hz, duration is in milliseconds
{
   StartTone(frequency);
   Delay(duration);
   StopTone();
}

StartTone(frequency) // start 8253 programmable timer playing this frequency
{
   // determine counter to send to the 8253 programmable timer
   #define  CHIP_RATE   1193180
   counter = CHIP_RATE / frequency;
   // program 8253
   #define  COUNTER_REGISTER  0x42
   #define  COMMAND_REGISTER  0x43
   #define  SPEAKER_REGISTER  0x61
   speaker = inport(SPEAKER_REGISTER);
   if ( !(speaker & 0x3) ) {
      speaker |= 0x3;
      outport(SPEAKER_REGISTER,speaker);
      outport(COMMAND_REGISTER,0xB6);
   }
   outport(COUNTER_REGISTER,counter & 0xFF);
   outport(COUNTER_REGISTER,(counter >> 8) & 0xFF);
}

StopTone()
{
   outport(SPEAKER_REGISTER,inport(SPEAKER_REGISTER) & 0xfc);
}

Delay(duration) // duration is in milliseconds, approximately
{
   EndTime = clock() + (duration / 1000.0) * CLOCKS_PER_SEC;
   while( clock() < endTime ) ;
}


Instructions()
{
   printf("\a\n")
   printf("Sound - Sound a specified tone on the internal speaker for specified time\n")
   printf("\n")
   printf("SYNTAX:  SOUND Freqency Duration\n")
   printf("\n")
   printf("Where:  Frequency     Tone in hertz\n")
   printf("        Duration      In milliseconds, accurate to %d milliseconds\n",1000/CLOCKS_PER_SEC)
   printf("\n")
   printf("The following example would play middle A for 2 seconds:\n");
   printf("    SOUND 440 2000\n")
   printf("\n")
}

:CENVI_EXIT
