/* hw.c - Windows program with "Hello World" icon */

#include <windows.h>
#include "hw.h"
/* CMAKE - INCLUDE END */

HANDLE hInst ;

int PASCAL WinMain ( HANDLE hInstance     ,
                     HANDLE hPrevInstance ,
                     LPSTR  lpCmdLine     ,
                     int    nCmdShow        )

{
WNDCLASS wc      ;
HWND     hWnd    ;
MSG      message ;

if ( ! hPrevInstance )

   {
   wc.style = NULL ;

   wc.lpfnWndProc = MainWndProc ;

   wc.cbClsExtra = 0 ;

   wc.cbWndExtra = 0 ;

   wc.hInstance = hInstance ;

   wc.hIcon = LoadIcon ( hInstance    ,
                         "HelloWorld"   ) ;

   wc.hCursor = LoadCursor ( NULL      ,
                             IDC_ARROW   ) ;

   wc.hbrBackground = GetStockObject ( WHITE_BRUSH ) ;

   wc.lpszMenuName =  "HWMenu" ;

   wc.lpszClassName = "HWWClass" ;

   if ( ! ( RegisterClass ( & wc ) ) )

      {
      return ( FALSE ) ;
      }
   }

hInst = hInstance ;

if ( ! ( hWnd = CreateWindow ( "HWWClass"           ,
                               "Sample Program"     ,
                               WS_OVERLAPPEDWINDOW  ,
                               CW_USEDEFAULT        ,
                               CW_USEDEFAULT        ,
                               CW_USEDEFAULT        ,
                               CW_USEDEFAULT        ,
                               NULL                 ,
                               NULL                 ,
                               hInstance            ,
                               NULL                   ) ) )

   {
   return ( FALSE ) ;
   }

else

   {
   ShowWindow ( hWnd     ,
                nCmdShow   ) ;

   UpdateWindow ( hWnd ) ;
   }

while ( GetMessage ( & message ,
                     NULL      ,
                     NULL      ,
                     NULL        ) )
      {
      TranslateMessage ( & message ) ;

      DispatchMessage ( & message ) ;
      }

return ( message
           .wParam ) ;
}


long FAR PASCAL MainWndProc ( HWND     hWnd    ,
                              unsigned message ,
                              WORD     wParam  ,
                              LONG     lParam    )

{
FARPROC lpProcAbout ;

switch ( message )

       {
       case WM_COMMAND :

            if (    wParam
                 == IDM_ABOUT )

               {
               lpProcAbout = MakeProcInstance ( About ,
                                                hInst   ) ;

               DialogBox ( hInst       ,
                           "AboutBox"  ,
                           hWnd        ,
                           lpProcAbout   ) ;

                FreeProcInstance ( lpProcAbout ) ;

                break ;
                }

            else

                {
                return ( DefWindowProc ( hWnd    ,
                                         message ,
                                         wParam  ,
                                         lParam    ) ) ;
                }

       case WM_DESTROY :

            PostQuitMessage ( 0 ) ;

            break ;

       default :

            return ( DefWindowProc ( hWnd    ,
                                     message ,
                                     wParam  ,
                                     lParam    ) ) ;

            break ;
       }

return ( NULL ) ;
}


BOOL FAR PASCAL About ( HWND     hDlg    ,
                        unsigned message ,
                        WORD     wParam  ,
                        LONG     lParam    )

{
switch ( message )

       {
       case WM_INITDIALOG :

            return ( TRUE ) ;

       case WM_COMMAND :

            if (    (    wParam
                      == IDOK   )
                 || (    wParam
                      == IDCANCEL ) )

               {
               EndDialog ( hDlg ,
                           TRUE   ) ;

               return ( TRUE ) ;
               }

            break ;
       }

return ( FALSE ) ;
}
