#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "bmp.h"

int match ( FILE *f ) {

	char s[10] ;
	int i ;

	while ( !feof( f ) ) {
		fscanf( f, "%4s", s ) ;
		if ( !strncmp( s, "0x", 2 ) ) {
			sscanf( &s[2], "%x", &i ) ;
			return i ;
		}
	}
	return 0 ;
}

char **readmap ( FILE *f, int w, int h ) {

	char **b ;
	int p, i, j, k ;

	b = new char * [w] ;
	for ( i = 0 ; i < w ; i++ )
		b[i] = new char [h] ;
	for ( i = 0 ; i < h ; i++ )
		for ( j = 0 ; j < w ; j += 8 ) {
			p = match( f ) ;
			for ( k = j ; k < j + 8 && k < w ; k++ ) {
				b[k][h - i - 1] = p & 0x80 ? 1 : 0 ;
				p <<= 1 ;
			}
		}
	return b ;
}

main ( int argc, char **argv ) {

	editmap *edit ;
	FILE *f ;
	char a, **b = NULL ;
	int w, h ;

	if ( argc != 2 && argc != 3 ) {
usage :		puts( "fe <filename> [WIDTHxHEIGHT]\n"
			"WIDTH and HEIGHT must be less tahn 84\n"
			"For example:\n"
			"To edit a new file: FE TEST 32x32\n"
			"To edit an existed file: FE TEST"
		);
		exit( -1 ) ;
	}

	if ( argc == 3 ) {
		if ( ( f = fopen( argv[1], "rt" ) ) != NULL )
			goto okfile ;
		sscanf( argv[2], "%dx%d", &w, &h ) ;

	} else if ( argc != 2 )
		goto usage ;
	else {
		if ( ( f = fopen( argv[1], "rt" ) ) == NULL )
			goto usage ;
okfile :	fscanf( f, "%*s %*s %*s %*s %*s %*s %d, %d } ;", &w, &h ) ;
		w++; h++;
		b = readmap( f, w, h ) ;
		fclose( f ) ;
	}
	if ( w > 84 || h > 84 || w <= 0 || h <= 0 )
		goto usage ;


	if ( !msm_init() || !fg_init_all() ) {
		fputs( "Cannot initialize display device", stderr ) ;
		exit( -1 ) ;
	}
	msm_setareax( 0, fg.displaybox[FG_X2] ) ;
	msm_setareay( 0, fg.displaybox[FG_Y2] ) ;
	msm_showcursor() ;

	edit = new editmap ( w, h, argv[1] ) ;
	if ( b ) {
		edit->copymap( b ) ;
		delete b ;
	}
	edit->expose() ;
	edit->focus() ;
	delete edit ;
	fg_term() ;
	return 0 ;
}

int fg_init_all() { return fg_init_vga12() ; }

