/*** MODEM_IO.C ***/

#include <stdio.h>
#include "pcl4c.h"
#include "ascii.h"
#include "term.h"

#define FALSE 0
#define TRUE !FALSE
#define SECONDS 18

/* NOTE: Requires AT COMMAND SET for all functions in this file */

#if AT_COMMAND_SET

int SendTo(int,char *);
int WaitFor(int,char *);
void CmdState(int);
void Hangup(int);

/*** send string to modem & get echo ***/

int SendTo(Port,String)
int Port;       /* port to talk to */
char *String;   /* string to send to mdoem */
{int i;
 char c;
 int Code;
 SioRxFlush(Port);
 SioDelay(SECONDS/4);
 for(i=0;i<strlen(String);i++)
    {/* User BREAK ? */
     if(BreakTest()) return(FALSE);
     /* fetch character */
     c = toupper( String[i] );
     switch(c)
        {case '!':
            /* replace ! with carriage return */
            c = CR;
            break;
         case '~':
            /* delay 1/2 second */
            SioDelay(SECONDS/2);
            c = ' ';
            break;
         case ' ':
            /* delay 1/4 second */
            SioDelay(SECONDS/4);
            break;
        } /* end switch */
     /* transmit as 7 bit character */
     PutChar(Port,(char)(0x7f & c));
     /* delay 3/18th of a second */
     SioDelay(3);
     /* wait up to 1 second for the echo */
     Code = GetChar(Port,SECONDS);
     if(Code>0) SioCrtWrite((char)Code);
    }
 return(TRUE);
} /* end SendTo */

/*** wait for incoming string from modem ***/

int WaitFor(Port,String)
int Port;       /* Port to talk to */
char *String;   /* string to wait for */
{int i, k;
 char c;
 int Code;
 SioCrtWrite(LF);
 /* flush leading LFs and CRs */
 while(1)
    {/* User BREAK ? */
     if(BreakTest()) return(FALSE);
     /* get next incoming character */
     Code = GetChar(Port,2*SECONDS);
        /* printf("{\n%x}",Code); */
     if(Code==-1) break;
     /* skip any leading CR or LF */
     if(((char)Code!=LF)&&((char)Code!=CR))
        {/* stuff character back & break out of loop */
         SioUnGetc(Port,(char)Code);
         break;
        }
     SioDelay(SECONDS/5);
    }
 /* wait for string */
 for(i=0;i<strlen(String);i++)
    {/* User BREAK ? */
     if(BreakTest()) return(FALSE);
     c = String[i];
     /* wait up to 1 second for next character */
     Code = GetChar(Port,SECONDS);
        /* printf("(\n%x)",Code);*/
     if(Code==-1) return(FALSE);
     SioCrtWrite((char)Code);
     if((char)Code != c)
        {printf("\nExpecting %xH not %xH\n",c,Code);
         return(FALSE);
        }
    } /* end for(i) */
 /* another character ? */
 Code = GetChar(Port,SECONDS);
 if(Code>0) SioCrtWrite((char)Code);
 return(TRUE);
} /* end WaitFor */

/*** enter command state ***/

/* NOTE: assumes escape char = '+' & guard time = 1 sec */

void CmdState(Port)
int Port;       /* Port to talk to */
{int i;
 /* delay a bit over 1 second */
 SioDelay(20);
 /* send Escape Code exactly 3 times */
 for(i=0;i<3;i++)
    {SioPutc(Port,'+');
     SioDelay(4);
    }
 /* delay again */
 SioDelay(16);
} /* end CmdState */

/*** hangup phone (in command state) ***/

void Hangup(Port)
int Port;       /* Port to talk to */
{/* enter command state */
 CmdState(Port);
 /* hangup ! */
 SendTo(Port,"!AT!");
 SendTo(Port,"ATH0!");
} /* end Hangup */

static int BreakTest()
{/* User BREAK ? */
 if(SioBrkKey())
    {printf("User BREAK\n");
     return(TRUE);
    }
 else return(FALSE);
} /* end BreakTest */
#endif
