;
; VIDEO2.ASM - Draw box and set attribute without CGA snow.
;              These functions are from the book "User Interfaces in C"
;              and are on pages 23-37.


bios_data		equ		40h
crt_mode_set	equ		65h
lprog			equ		1
ldata			equ		0

DGROUP			group	_DATA
_DATA			segment	word public 'DATA'
				assume ds:DGROUP

EXTRN		_VideoSeg:word			; see scr.h

ULC			db		218,201,213,214
URC			db		191,187,184,183
LLC			db		192,200,212,211
LRC			db		217,188,190,189
HL			db		196,205,205,196
VL			db		179,186,179,186

_DATA			ends


_TEXT			segment para public 'CODE'
				assume cs:_TEXT

				public 	_SetAttrib, _DrawBox, _WaitKey, _ClearScr
				public  _SaveScreen, _RestoreScreen, _PutChr

;
; void SetAttrib(int att, int col1, int row1, int col2, int row2);
;
_SetAttrib		proc	near
att				equ		[bp+4]
col1			equ		[bp+6]
row1			equ		[bp+8]
col2			equ		[bp+10]
row2			equ		[bp+12]
rows			equ		[bp-2]
cols			equ		[bp-4]

				push	bp
				mov		bp,sp
				sub		sp,4

				push	di				;Save the registers
				push	es
				mov		ax,row1			;Figure the video offset
				mov		bx,col1
				call	fig_vid_off
				mov		di,ax			;DI=Video offset
				inc		di				;Bump it to the first attribute
				mov		ax,_VideoSeg   	;ES=Video segment
				mov		es,ax
				mov		ax,row2			;Figure the number of rows
				sub		ax,row1
				inc		ax
				mov		rows,ax			;Save it
				mov		ax,col2			;Figure the number of columns
				sub		ax,col1
				inc		ax
				mov		cols,ax			;Save it
				cld						;Flag increment
				mov		al,byte ptr att	;AL=Display attribute
				call	disable_cga		;Disable CGA if necessary
setattrib1:		push	di				;Save the video offset
				mov		cx,cols			;CX=Number of columns
setattrib2:		stosb					;Set the attribute byte
				inc		di				;Bump the video pointer
				loop	setattrib2		;Loop till done
				pop		di				;Restore the video offset
				add		di,160			;Point it to the next row
				dec		word ptr rows	;Loop till done
				jnz		setattrib1
				call	enable_cga		;Enable the CGA if necessary
				pop		es				;Restore the registers
				pop		di

				mov		sp,bp
				pop		bp

				ret						;Return
_SetAttrib		endp

;
; void DrawBox(int col1, int row1, int col2, int row2, int flag, int att);
;
_DrawBox		proc	near
col1			equ		[bp+4]
row1			equ		[bp+6]
col2			equ		[bp+8]
row2			equ		[bp+10]
flag			equ		[bp+12]
att				equ		[bp+14]
rows			equ		[bp-2]
cols			equ		[bp-4]


				push	bp
				mov		bp,sp
				sub		sp,10

				push	di				;Save the registers
				push	si

				mov		si,word ptr flag	;SI=Line style flag
				push	es
				mov		ax,row1			;Figure the video offset
				mov		bx,col1
				call	fig_vid_off
				mov		di,ax			;DI=Video offset
				mov		ax,_VideoSeg   	;ES=Video segment
				mov		es,ax
				mov		ax,row2			;Figure the # of rows - 2
				sub		ax,row1
				dec		ax
				mov		rows,ax			;Save it
				mov		ax,col2			;Figure the # of cols - 2
				sub		ax,col1
				dec		ax
				mov		cols,ax			;Save it
				cld						;Flag increment
				mov		ah,att			;AH=Display attribute
				call	disable_cga		;Disable CGA if necessary
				push	di				;Save the video offset

				;Upper left corner
				mov		al,byte ptr ULC[si]

drawbox1:		stosw					;Save the character/attribute pair

				;Top horzontal line
				mov		al,byte ptr HL[si]

drawbox2:		mov		cx,cols			;CX=Line length
				rep		stosw			;Display the line

				;Upper right corner
				mov		al,byte ptr URC[si]

drawbox3:		stosw					;Save the character/attribute pair
				pop		di				;Restore the video pointer
				add		di,160			;Point it to the next row
drawbox4:		push	di				;Save the video pointer

				;Vertical lines
				mov		al,byte ptr VL[si]

drawbox5:		stosw					;Save the character/attribute pair
				add		di,cols			;Point to
				add		di,cols			;the right side
				stosw
				pop		di				;Restore the video pointer
				add		di,160			;Point it to the next row
				dec		word ptr rows	;Loop till the
				jnz		drawbox4		;sides are complete

				;Lower left corner
				mov		al,byte ptr LLC[si]

drawbox6:		stosw

				;Bottom horizontal line
				mov		al,byte ptr HL[si]

drawbox7:		mov		cx,cols			;CX=Line length
				rep		stosw			;Display the line

				;Lower right corner
				mov		al,byte ptr LRC[si]

drawbox8:		stosw
				call	enable_cga		;Enable CGA if necessary
				pop		es				;Restore the registers
				pop		si
				pop		di

				mov		sp,bp
				pop		bp
				ret						;Return
_DrawBox		endp


;
; void PutChr(inr col, int row, int attr, char chr);
;
_PutChr			proc	near
col		equ		<4[bp]>
row		equ		<6[bp]>
attr	equ		<8[bp]>
chr		equ		<10[bp]>

		push	bp
		mov		bp,sp
		sub		sp,10

		push	di					; Save the registers
		push	si
		push	es

		mov		ax,row
		mov		bx,col
		call	fig_vid_off
		mov		di,ax
		mov		ax,_VideoSeg			; CGA only
		mov		es,ax
		cld							; Flag increment
		mov		ah,attr
		;call	disable_cga
		push	di
		mov		al,chr
		stosw						; Save the char/attr pair
		pop		di
		;call	enable_cga
		pop		es
		pop		si
		pop		di

		mov		sp,bp
		pop		bp
		ret
_PutChr		endp


;
; void SaveScreen(int col1, int row1, int col2, int row2, char array);
;
_SaveScreen		proc	near
col1	equ		<4[bp]>
row1	equ		<6[bp]>
col2	equ		<8[bp]>
row2	equ		<10[bp]>
array	equ		<12[bp]>
rows	equ		<-2[bp]>
cols	equ		<-4[bp]>

				push	bp
				mov		bp,sp
				sub		sp,4

				push	di				;Save the registers
				push	si
				push	es

				mov		ax,row1			;Figure the video offset
				mov		bx,col1
				call	fig_vid_off
				mov		si,ax			;SI=Video offset
				mov		ax,row2			;Figure the number of rows
				sub		ax,row1
				inc		ax
				mov		rows,ax			;rows = row2 - row1 + 1
				mov		ax,col2			;Figure the number of columns
				sub		ax,col1
				inc		ax				;cols = col2 - col1 + 1
				mov		cols,ax			;Save it
				cld						;Flag increment
				call	disable_cga
				push	ds
				if		ldata
				les		di,array		;ES:DI=Array pointer
				else
				push	ds
				pop		es
				mov		di,array
				endif
				mov		ds,_VideoSeg
savescreen1:	push	si
				mov		cx,cols
				rep		movsw
				pop		si
				add		si,160
				dec		word ptr rows
				jnz		savescreen1
				pop		ds
				call	enable_cga
				pop		es
				pop		si
				pop		di

				mov		sp,bp
				pop		bp
				ret
_SaveScreen		endp


;
;void RestoreScreen(int col1, int row1, int col2, int row2, char array);
;
_RestoreScreen	proc	near
col1	equ		<4[bp]>
row1	equ		<6[bp]>
col2	equ		<8[bp]>
row2	equ		<10[bp]>
array	equ		<12[bp]>
rows	equ		<-2[bp]>
cols	equ		<-4[bp]>

				push	bp				;Save BP
				mov		bp,sp
				sub		sp,4

				push	di				;Save the registers
				push	si
				push	es
				mov		ax,row1			;Figure the video offset
				mov		bx,col1
				call	fig_vid_off
				mov		di,ax
				mov		es,_VideoSeg
				mov		ax,row2			;Figure the number of rows
				sub		ax,row1
				inc		ax
				mov		rows,ax
				mov		ax,col2			;Figure the number of columns
				sub		ax,col1
				inc		ax
				mov		cols,ax
				cld
				call	disable_cga
				if		ldata
				push	ds
				lds		si,array
				else
				mov		si,array
				endif
restorescreen1:	push	di				;Save the video offset
				mov		cx,cols
				rep		movsw
				pop		di
				add		di,160
				dec		word ptr rows
				jz		restorescreen1
				if		ldata
				pop		ds
				endif
				call	enable_cga
				pop		es
				pop		si
				pop		di

				mov		sp,bp
				pop		bp
				ret
_RestoreScreen	endp


;
; void WaitKey(void);
;
_WaitKey		proc	near
iskey:			mov		ah,01h				;Has a key
				int		16h					;been pressed?
				jz		iskey				;Loop if not
				mov		ah,0				;Get the key
				int		16h
				or		al,al				;Jump if
				jz		wait_key1			;extended key
				xor		ah,ah				;Erase the scan code
				jmp		short wait_key2		;Jump
wait_key1:		xchg	ah,al				;AX=Scan code
				inc		ah					;AX=Scan code + 256
wait_key2:		ret							;Return
_WaitKey		endp


;
; void ClearScr(int col1, int row1, int col2, int row2, int att);
;
_ClearScr		proc	near
col1			equ		[bp+4]
row1			equ		[bp+6]
col2			equ		[bp+8]
row2			equ		[bp+10]
att				equ		[bp+12]

				mov		ah,06h
				mov		al,0
				mov		dh,row2
				mov		dl,col2
				mov		ch,row1
				mov		cl,col1
				mov		bh,att
				int		10h
_ClearScr		endp


;-------------------------- Local functions

;
; Figure video offset
;
fig_vid_off		proc	near
				push	dx					;Save DX
				push	bx					;Save the column
				mov		bx,160				;Figure the
				mul		bx					;Row offset
				pop		bx					;Restore the column
				sal		bx,1				;Figure the column pair offset
				add		ax,bx				;AX=Video offset
				pop		dx					;Restore DX
				ret							;Return
fig_vid_off		endp


;
;Disable CGA
;
disable_cga		proc	near
				push	ax					;Save the registers
				push	dx
				mov		dx,3dah				;DX=Video status port
disable_cga1:	in		al,dx				;Wait
				and		al,8				;for
				jz		disable_cga1		;vertical retrace
				mov		dl,0d8h				;DX=Video select register port
				mov		al,25h				;Disable the video
				out		dx,al
				pop		dx					;Restore the registers
				pop		ax
				ret
disable_cga		endp

;
;Enable CGA
;
enable_cga		proc	near
				push	ax					;Save the registers
				push	bx
				push	dx
				push	ds
				mov		ax,bios_data		;Set the data segment
				mov		ds,ax
				mov		bx,crt_mode_set 	;BX=Video mode set value pointer
				mov		al,[bx]				;AX=Video mode set value
				mov		dx,03d8h			;DX=Video select register port
				out		dx,al				;Reenable the video mode
				pop		ds					;Restore the registers
				pop		dx
				pop		bx
				pop		ax
				ret
enable_cga		endp
_TEXT			ends
				end



