/**********************************************************/
/* File Id.                  Clr_Wnd.C                    */
/* Date Written.             05/14/89.                    */
/*                                                        */
/*         (c) Copyright 1989, 1990 by Stan Milam         */
/*                                                        */
/* Comments:  Used to clear a window.  If action flag is  */
/* non-zero the area inside the borders will be cleared   */
/* otherwise the whole window (including borders) will be */
/* cleared. The color specified when framing the window   */
/* will be used.                                          */
/**********************************************************/

#include "pcw.i"
#include "pcwproto.h"

int clr_wnd(WNDPTR *wnd, int action) {

    int urow, ucol, lrow, lcol;                  /* Scratch Stuff */
    int foreground, background;

    if (!wnd) return(0);
    if (!chk_video_state(&urow,&ucol)) return(0);
    re_order(wnd, NORMAL);                       /* Reorder the window */
    urow = wnd->urow;                            /* Get rows and cols */
    ucol = wnd->ucol;
    lrow = wnd->lrow;
    lcol = wnd->lcol;
    set_cursor_pos(urow+1,ucol+1);
    if (action) {                                /* If action non-zero */
       urow++; ucol++;                           /* Clear inside of borders */
       lrow--; lcol--;
    }
    background = (wnd->attr & 0xf0) >> 4;        /* Get the color attributes */
    foreground = wnd->attr &0x0f;
    return(qfill(urow, ucol, lrow, lcol, foreground, background, 32));
}
