/***************************************************************/
/* File Id.                     DEMOS.C.                       */
/* Author.                      Stan Milam.                    */
/* Date Written.                21 Dec. 91.                    */
/*                                                             */
/* This file contains the menuing code that acts as an umbrella*/
/* for all the demo routines.                                  */
/*                                                             */
/***************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pcwproto.h"
#include "menu.h"
#include "keys.h"

int demo_a( void );
int demo_b( void );
int demo_c( void );
int demo_d( void );
int demo_e( void );

int demos_menu( void ) {

    int choice = 0;
    WNDPTR *menuwnd;

    static PMNUFLDS DemoOptions[] = {
        { 'A', "A. Ratting Around  " },
        { 'B', "B. C Advertisment  " },
        { 'C', "C. PCW On The Move " },
        { 'D', "D. Life is Random  " },
        { 'E', "E. Scrolling Around" },
        { 'Q', "Q. Quit.           " },
        {   0, NULL                  }
    };

    static PMNUTYPE DemoMenu = {
        NULL,
        3,15,10,36,
        YELLOW, BLUE,
        SINGLEALL, LIGHTGRAY, BLUE,
        "",
        TOP, MIDDLE, LIGHTGRAY, BLUE,
        YELLOW, MAGENTA, 0,
        DemoOptions
    };

    if (mpresent) hide_mouse();
    menuwnd = makepmenu(&DemoMenu);
    if (mpresent) show_mouse();
    while ( choice != 'Q' && choice != ESC ) {
        choice = pmenuinput( &DemoMenu );
        switch ( choice ) {
            case 'A' : demo_a(); break;
            case 'B' : demo_b(); break;
            case 'C' : demo_c(); break;
            case 'D' : demo_d(); break;
            case 'E' : demo_e(); break;
            case 'Q' :
            case ESC : continue;
        }
    }
    if ( mpresent ) hide_mouse();
    menuwnd = wpop( menuwnd );
    DemoMenu.pwnd.wnd = NULL;
    if ( mpresent ) show_mouse();
    return 0;
}


