
/* files.c
   25nov91
   cb
   files functions
*/

/* === includes ======================================== */
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <ctype.h>

#include "pcwproto.h"
#include "menu.h"

#include "files.h"

/* === defines ========================================= */
#define FALSE 0
#define TRUE  1
#define ESC 0x1B
#define EVER ;;

/* === prototypes ====================================== */
static  int cmd_d(void);   /* get_Directory cmd */
static  int cmd_h(void);   /* go_Shell cmd */
static  int cmd_l(void);   /* file_Load cmd */
static  int cmd_n(void);   /* file_New cmd */
static  int cmd_s(void);   /* file_Save cmd */
static  int cmd_w(void);   /* file_Write cmd */
void wait_for_something(void); /* wait for key or mse */

/* === files_menu() ==================================== */
int files_menu(void)   /* do files */
{
   int cmd, result;
   int i = 0;
   WNDPTR *menuwnd;

   static PMNUFLDS filesoptions[] =
      {{ 'L', " Load        "},
       { 'N', " New         "},
       { 'S', " Save        "},
       { 'W', " Write to ..."},
       { 'D', " Directory   "},
       { 'H', " sHell       "},
       { 'Q', " Quit        "},
       {  0 , NULL }};

   static PMNUTYPE filesmenu =
      { NULL,                         /* initial window ptr    */
         3, 2, 11, 17,                /* window boundaries     */
        YELLOW, BLUE,                 /* window color          */
        SINGLEALL, LIGHTGRAY, BLUE,   /* border type and color */
        "",                           /* menu title            */
        TOP, MIDDLE, BLUE, LIGHTGRAY, /* title loc and color   */
        YELLOW, MAGENTA,              /* select bar color      */
        0,                            /* initial bar position  */
        filesoptions };               /* ptr to options array  */

   if (mpresent) hide_mouse();
   menuwnd = makepmenu(&filesmenu); /* create pop-up menu */
   if (mpresent) show_mouse();
   while (i != 'Q' && i != ESC)
   {
      i = pmenuinput(&filesmenu);   /* get value from menu */
      switch(i)
      {
         case 'L': cmd = LOAD; break;
         case 'N': cmd = NEW; break;
         case 'S': cmd = SAVE; break;
         case 'W': cmd = WRITE; break;
         case 'D': cmd = DIR; break;
         case 'H': cmd = SHELL; break;
      }
      if(i == 'Q' || i == ESC) result = 0;
      else result = file(cmd);
   }
   if(mpresent) hide_mouse();
   menuwnd = wpop(menuwnd);
   if(mpresent) show_mouse();

   return(result);
}
/* --- end files_menu() -------------------------------- */


/* === file() ========================================== */
int file(int cmd)   /* do file functions */
{
   int result;
   switch(cmd)
   {
      case   LOAD: result = cmd_l(); break;
      case    NEW: result = cmd_n(); break;
      case   SAVE: result = cmd_s(); break;
      case  WRITE: result = cmd_w(); break;
      case    DIR: result = cmd_d(); break;
      case  SHELL: result = cmd_h(); break;
          default: result = 99;
   }

   return(result);
}
/* --- end file() -------------------------------------- */


/* === cmd_d() ========================================= */
static int cmd_d(void)   /* do dos Directory cmd */
{
    WNDPTR *wnd;
    int mxr, mxc;

    if(mpresent) hide_mouse();
    chk_video_state(&mxr, &mxc);
    bordercolor(YELLOW, BLUE);
    wnd = wframe(1, 18, 25, 59, LIGHTGRAY, BLUE);
    wtitle(wnd, BOTTOM, RITE, " CURRENT DIRECTORY ");
    set_int29();

    system("dir /p");

    puts("====== nifty! any key to return ======");
    reset_int29();
    if (mpresent) show_mouse();
    wait_for_something();
    if (mpresent) hide_mouse();
    wpop(wnd);
    if(mpresent) show_mouse();
    return(0);
}
/* --- end cmd_d() ------------------------------------- */


/* === cmd_h() ========================================= */
static int cmd_h(void)   /* do sHell cmd */
{
    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "go_sHell()");
    if(mpresent) show_mouse();

    wait_for_something();

    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "          ");
    if(mpresent) hide_mouse();

    return(0);
}
/* --- end cmd_h() ------------------------------------- */


/* === cmd_l() ========================================= */
static int cmd_l(void)   /* file_Load cmd */
{
    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "file_Load()");
    if(mpresent) show_mouse();

    wait_for_something();

    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "           ");
    if(mpresent) hide_mouse();

    return(0);
}
/* --- end cmd_l() ------------------------------------- */


/* === cmd_n() ========================================= */
static int cmd_n(void)   /* file_New cmd */
{
    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "file_New()");
    if(mpresent) show_mouse();

    wait_for_something();

    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "          ");
    if(mpresent) hide_mouse();

    return(0);
}
/* --- end cmd_n() ------------------------------------- */


/* === cmd_s() ========================================= */
static int cmd_s(void)   /* go_Shell cmd */
{
    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "file_Save()");
    if(mpresent) show_mouse();

    wait_for_something();

    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "           ");
    if(mpresent) hide_mouse();

    return(0);
}
/* --- end cmd_s() ------------------------------------- */


/* === cmd_w() ========================================= */
static int cmd_w(void)   /* file_Write cmd */
{
    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "file_Write()");
    if(mpresent) show_mouse();

    wait_for_something();

    if(mpresent) hide_mouse();
    qputs(12,CENTER,WHITE,BLACK, "            ");
    if(mpresent) hide_mouse();

    return(0);
}
/* --- end cmd_w() ------------------------------------- */

