/**********************************************************/
/* File Id.                  Fload.C                      */
/* Author.                   Stan Milam.                  */
/* Date Written.             10/24/89.                    */
/*                                                        */
/*           (c) Copyright 1989-90 by Stan Milam          */
/*                                                        */
/* Comments:  Used to set 43/25 line mode with an EGA and */
/* 50/28/25 line mode with the VGA.  Checks are made to   */
/* ensure that invalid calls (based on video adapter) are */
/* not made.                                              */
/*   Fonts:                                               */
/*      8x8  - 43 line EGA, 50 line VGA                   */
/*      8x14 - 25 line EGA, 28 line VGA                   */
/*      8x16 - 25 line VGA                                */
/* Reference: Programmer's Guide to EGA & VGA by Ferraro. */
/**********************************************************/

#include <stdio.h>
#include <dos.h>
#include "pcwproto.h"

void fload(int block, int font) {

   union REGS regs;
   int   mxr, mxc, tline, bline;
   char  far  *egabyte = (char far *) MK_FP(0,0x487);
   char  egasave;

   chk_video_state(&mxr,&mxc);                   /* Make sure we're init */
   if (_adaptor > CGA) {                         /* Must have EGA or VGA */
      get_cursor_size(&tline,&bline);            /* Get the cursor size */
      switch(font) {                             /* Edit the fonts */
         case  8 :
         case 14 :
         case 16 : break;
         default : return;
      }
      if (font == 16) {                          /* Must be VGA for this */
         if (_adaptor == VGA) regs.x.ax = 0x1114;/* So we check it */
         else return;
      }
      else {                                     /* Must be 14 or 8 */
         if (font == 14) regs.x.ax = 0x1111;
         else regs.x.ax = 0x1112;                /* Has to be 8! */
      }
      regs.h.bl = (char) block;                  /* Set the block */
      int86(0x10,&regs,&regs);                   /* Call BIOS to load font */
      egasave = *egabyte;                        /* Get EGA misc info byte */
      if (font == 8) {                           /* Going to 43 line mode */
         *egabyte = (char) (egasave | 1);        /* Toggle 8x8 emulation */
         set_cursor_size(tline,bline);           /* Set the cursor size */
      }
      else {                                     /* 43/50 to 25 line mode */
         *egabyte = (char) (egasave & 0xfe);     /* Turn 8x8 emulation off */
         set_cursor_size(tline,bline);
      }
   }
}
