/* $no list */ /*$no trace <<<keys.h>>> */
/**********************************************************/
/* File Id.                  Keys.H.                      */
/* Author.                   Stan Milam.                  */
/*                                                        */
/*          (c) Copyright 1989-91 by Stan Milam           */
/*                                                        */
/* Comments: Used to define special keys.                 */
/* Updated 12 Aug. 91 to work with new keyboard routines  */
/* which greatly expand keyboard abilities.               */
/*                                                        */
/**********************************************************/

#define CR    0x000d
#define ESC   0x001b
#define ENTER 0x000a

/* Normal function keys */

#define F1   0x3b00
#define F2   0x3c00
#define F3   0x3d00
#define F4   0x3e00
#define F5   0x3f00
#define F6   0x4000
#define F7   0x4100
#define F8   0x4200
#define F9   0x4300
#define F10  0x4400

/* Shifted function keys */

#define SHFTF1  0x5400
#define SHFTF2  0x5500
#define SHFTF3  0x5600
#define SHFTF4  0x5700
#define SHFTF5  0x5800
#define SHFTF6  0x5900
#define SHFTF7  0x5a00
#define SHFTF8  0x5b00
#define SHFTF9  0x5c00
#define SHFTF10 0x5d00

/* Function keys combinded with Ctrl key */

#define CTRLF1  0x5e00
#define CTRLF2  0x5f00
#define CTRLF3  0x6000
#define CTRLF4  0x6100
#define CTRLF5  0x6200
#define CTRLF6  0x6300
#define CTRLF7  0x6400
#define CTRLF8  0x6500
#define CTRLF9  0x6600
#define CTRLF10 0x6700

/* Function keys combined with Alt key */

#define ALTF1  0x6800
#define ALTF2  0x6900
#define ALTF3  0x6a00
#define ALTF4  0x6b00
#define ALTF5  0x6c00
#define ALTF6  0x6d00
#define ALTF7  0x6e00
#define ALTF8  0x6f00
#define ALTF9  0x7000
#define ALTF10 0x7100

/* Other special keys */

#define BACKSPACE  0x0008
#define TAB        0x0009
#define SHFTTAB    0x0f00
#define HOME       0x4700
#define UPARROW    0x4800
#define PGUP       0x4900
#define LEFTARROW  0x4b00
#define RITEARROW  0x4d00
#define END        0x4f00
#define DOWNARROW  0x5000
#define PGDN       0x5100
#define INS        0x5200
#define DEL        0x5300

/* Some psuedo keys for the mouse */

#define RITE_MOUSE_KEY 0xff00
#define LEFT_MOUSE_KEY 0Xfe00
#define BOTH_MOUSE_KEY 0xfd00

/*$list */ /*$trace <<<keys.h>>> */
