#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <pcwproto.h>
#include <menu.h>
#include <keys.h>



void help(void) {

   WNDPTR *wnd;
   static char *helpmsg[] = {
      "Use the menu to select which window you want to move around.",
      "Once you have made your selection use the arrow keys to move",
      "the window around the screen or use the mouse to point where",
      "you want to move the window and \"click\" with  the left mouse",
      "key.  To return to the menu use the right Mouse key  or  the",
      "escape key.  This help screen can be invoked from  the  menu",
      "or by using F1 when moving windows around.                  ",
      " ", "Press any key to return",""
   };

   bordercolor(LIGHTBLUE,BLACK);
   titlecolor(WHITE,RED);
   if (mpresent) hide_mouse();
   wnd = wframe(5, 5, 17, 75,YELLOW,BLACK);
   wtitle(wnd, TOP,LEFT," Friendly Help ");
   w_block_write(wnd,2,CENTER,helpmsg);
   for (;;) {
     if (keypressed()) {
        wpop(wnd); keybrd_flush();
        if (mpresent) show_mouse();
        return;
     }
     if (mpresent) {
        if (get_mpressed(RITEM) || get_mpressed(LEFTM)) {
           wpop(wnd);
           show_mouse();
           return;
        }
     }
   }
}

void move_window(WNDPTR *window) {

   int  *wnd, wr, wc, key;
   int  row, col, bstatus;

   wnd = (int *) window;
   wr  = wnd[4]; wc = wnd[5];
   for (;;) {
     if (kbhit()) {
        key = getch();
        if (key == 0) key = getch() + 128;
        key = toupper(key);
        switch(key) {
           case 'H' :
           case F1  : help(); break;
           case ESC : return;
           case UPARROW :
              wr -= 1;
              if (mpresent) hide_mouse();
              wndmove(window,wr,wc);
              if (mpresent) show_mouse();
              wr = wnd[4];
              break;
           case DOWNARROW :
              wr += 1;
              if (mpresent) hide_mouse();
              wndmove(window,wr,wc);
              if (mpresent) show_mouse();
              wr = wnd[4];
              break;
           case LEFTARROW :
              wc -= 1;
              if (mpresent) hide_mouse();
              wndmove(window,wr,wc);
              if (mpresent) show_mouse();
              wc = wnd[5];
              break;
           case RITEARROW :
              wc += 1;
              if (mpresent) hide_mouse();
              wndmove(window,wr,wc);
              if (mpresent) show_mouse();
              wc = wnd[5];
              break;
           default : break;
        }
     }
     if (mpresent) {
        if (get_mpressed(RITEM) || get_mpressed(LEFTM)) {
           get_mpos(&row,&col,&bstatus);
           switch(bstatus) {
              case 1 :
                 hide_mouse();
                 wndmove(window,row,col);
                 show_mouse();
                 wr = wnd[4]; wc = wnd[5];
                 break;
              case 2 : return;
              case 3 : help(); break;
           }
        }
     }
  }
}

int main(void) {

   WNDPTR *mwnd, *wnd1, *wnd2;
   int    selection, mtype;
   int    *wnd, wr, wc;

   static PMNUFLDS plist[] = {
          { '1', "1. Move Window One Around"},
          { '2', "2. Move Window Two Around"},
          { '3', "3. Move the Menu Around  "},
          { 'H', "H. Helpful Program Notes "},
          { 'E', "E. Exit Program.         "},
          { 0, (char *) 0}
   };

   static PMNUTYPE pmenu = {
      NULL,
      1,1,7,31,RED,LIGHTGRAY,
      SINGLESIDES,BLACK,LIGHTGRAY,
      " Moving Window Menu ", TOP, MIDDLE,BLUE,LIGHTGRAY,
      WHITE,BLUE,0,
      plist
   };

   bordercolor(BLACK,LIGHTGRAY);
   titlecolor(RED,LIGHTGRAY);
   wnd1 = wframe(1,33,7,53,BLUE,LIGHTGRAY);
   wtitle(wnd1,TOP,MIDDLE," Window One ");
   wnd2 = wframe(1,55,7,75,RED,LIGHTGRAY);
   titlecolor(BLUE,LIGHTGRAY);
   wtitle(wnd2,TOP,MIDDLE," Window Two ");
   init_mouse();
   if (mpresent) {
      mtype = MK_ATTR(YELLOW+BLINK,BLACK) | 4;
      set_mtype(0,0,mtype);
   }

   mwnd = makepmenu(&pmenu);
   wnd  = (int *) mwnd;
   do {
      if (mpresent) {
         wr = wnd[4]; wc = wnd[5];
         set_mpos(wr + 1, wc + 1);
      }
      selection = pmenuinput(&pmenu);
      switch (selection) {
         case '1' : move_window(wnd1); break;
         case '2' : move_window(wnd2); break;
         case '3' : move_window(mwnd); break;
         case 'H' : help(); break;
         default  : break;
      }
   } while (selection != 'E');
   hide_mouse(); init_mouse();
   return(0);
}
