/***************************************************************/
/* File Id.                     Palette.C                      */
/* Author.                      Stan Milam.                    */
/* Date Written.                28 Nov 89.                     */
/*                                                             */
/*           (c) Copyright 1989, 1990 by Stan Milam            */
/*                                                             */
/* Comments:  Routines to retrieve & set the EGA palette reg-  */
/* isters. Routines maintain an internal table containing attr-*/
/* ibute register values of the EGA.                           */
/***************************************************************/

#include <stdio.h>
#include <string.h>
#include <dos.h>
#include "pcwproto.h"

static char palette_regs[17];          /* Palette Register & Overscan */

/***************************************************************/
/*                       get_ega_palette()                     */
/*                                                             */
/* Retrieve the EGA palette values stored in ROM for the       */
/* specified mode.                                             */
/***************************************************************/

char *get_ega_palette(int mode) {

   unsigned far *ptr1, far *ptr2;
   int mxc, mxr;

   chk_video_state(&mxr, &mxc);
   if (_adaptor < EGA) return(NULL);
   ptr1 = (unsigned far *) MK_FP(0,0x4a8);
   ptr1 = (unsigned far *) MK_FP(*(ptr1 + 1), *ptr1);
   ptr2 = (unsigned far *) palette_regs;
   memset(palette_regs,'\0',17);       /* Clear Registers */
   movedata(*(ptr1+1),*ptr1+(mode*64)+35,FP_SEG(ptr2),FP_OFF(ptr2),16);
   return(palette_regs);
}

/***************************************************************/
/*                        set_palette()                        */
/*                                                             */
/* Change the value in the table, palette_regs[],              */
/***************************************************************/

void set_palette(int attr_reg, int color) {

    palette_regs[attr_reg] = (char) color;
}

/***************************************************************/
/*                       load_ega_palette()                    */
/*                                                             */
/* Use BIOS to load the values in palette_regs[] into the the  */
/* EGA palette attribute registers.                            */
/***************************************************************/

void load_ega_palette(void) {

   union  REGS  regs;
   struct SREGS sregs;
   unsigned far *ptr;

   ptr       = (unsigned far *) palette_regs;
   sregs.es  = FP_SEG(ptr);
   regs.x.dx = FP_OFF(ptr);
   regs.x.ax = 0x1002;
   int86x(0x10,&regs,&regs,&sregs);
}

/***************************************************************/
/*                       set_load_palette()                    */
/*                                                             */
/* Set a value in the palette table and load the palette table */
/* to the EGA registers in one fell swoop.                     */
/***************************************************************/

void set_load_palette(int attr_reg, int color) {

   set_palette(attr_reg, color);
   load_ega_palette();
}

