              Page ,132
;****************************************************************
;* File Id.                       Msintr.Asm.                   *
;* Author.                        Stan Milam.                   *
;* Date Written.                  7 Dec 89.                     *
;*                                                              *
;*            (c) Copyright 1989, 1990 by Stan Milam            *
;*                                                              *
;* Comments: Routines are the Microsoft C version of Turbo &    *
;* Power C version of intr().                                   *
;****************************************************************
;
              Dosseg
IFDEF POWERC
              .Model    Large
ELSE
              .Model    Large,C
ENDIF
              .Data
;
;********************************************************************
;* This data will be copied onto the stack and modified at runtime  *
;* to generate the correct interrupt.                               *
;********************************************************************
;
IntStart      Label     Byte
              Int       21h
              Retf
IntLen        Equ       ($-IntStart)+1
;
;********************************************************************
;* Start the code segment by declaring some space to save the Bp    *
;* register while we modify the stack at runtime.                   *
;********************************************************************
              .Code
BpSave        Dw        ?
;

DoInt         Proc      Near
              Xchg      Bp,Cs:Word Ptr[BpSave]
              Push      Ss
              Sub       Bp,IntLen
              Push      Bp
              Add       Bp,IntLen
              Xchg      Bp,Cs:Word Ptr[BpSave]
              Retf
DoInt         Endp
;
;****************************************************************
;*                             Intr()                           *
;*                                                              *
;* MSC version of intr(), useful for interrupts and such. Used  *
;* mainly because we need to pass values in Bp and get values   *
;* from flags for keyboard routines.                            *
;*                                                              *
;* Now used with Turbo C also because the intr() function in    *
;* Turbo C has terrible bug and will trash your program if not  *
;* careful.                                                     *
;*                                                              *
;* struct REGPACK {                                             *
;*     unsigned  r_ax, r_bx, r_cx, r_dx, r_bp;                  *
;*     unsigned  r_si, r_di, r_ds, r_es, r_flags;               *
;* };                                                           *
;* void intr(int intno, struct REGPACK far *regp);              *
;****************************************************************
;
              Public    Intr
IFDEF POWERC
Intr          Proc      Far
intrno        Equ       [Bp + 6]
regs          Equ       [Bp + 8]
              Push      Bp
              Mov       Bp,Sp
ELSE
Intr          Proc      intrno:word, regs:ptr
ENDIF
              Sub       Sp,IntLen
              Push      Ds
              Push      Es
              Push      Di
              Push      Si
              Mov       Ax,intrno
              Mov       [IntStart + 1],Al   ;Use correct interrupt number
              Mov       Cx,IntLen
              Push      Ss                  ;Set Es:Di to point into
              Pop       Es                  ;the stack where we will
              Mov       Di,Bp               ;copy the code and modify it
              Sub       Di,IntLen
              Mov       Si,Offset IntStart
              Cld
              Rep       Movsb                           ;Copy Code onto Stack
              Push      Bp                              ;Save Bp for later use
              Pop       Cs:Word Ptr[BpSave]             ;In the code segment.
              Les       Bx,regs                         ;Es:Bx points to regs
              Mov       Cx,Word Ptr Es:[Bx + 4h]        ;Get Cx
              Mov       Dx,Word Ptr Es:[Bx + 6h]
              Mov       Bp,Word Ptr Es:[Bx + 8h]
              Mov       Si,Word Ptr Es:[Bx + 10]
              Mov       Di,Word Ptr Es:[Bx + 12]
              Mov       Ds,Word Ptr Es:[Bx + 14]
              Mov       Ax,Word Ptr Es:[Bx + 2h]        ;This is Bx-later
              Push      Bx                              ;Save Bx
              Push      Es                              ;and Es for later
              Push      Ax                              ;Save val for Bx
              Mov       Ax,Word Ptr Es:[Bx + 0h]        ;Get Real Ax
              Mov       Es,Word Ptr Es:[Bx + 16]        ;Get Es
              Pop       Bx                              ;Get in Bx finally
              Push      Cs                              ;Do this for Powerc
              Call      DoInt                           ;Make near call
CodeRet:                                                ;Return from Int here
              Push      Es
              Push      Bx
              Push      Bp
              Mov       Bp,Sp
              Mov       Bx,[Bp + 8]                     ;Get Bx & Es 
              Mov       Es,[Bp + 6]                     ;From up above
              Pop       Bp
              Mov       Word Ptr Es:[Bx + 0h],Ax
              Pop       Ax                              ;Pop of Bx
              Mov       Word Ptr Es:[Bx + 2h],Ax        ;Store it
              Mov       Word Ptr Es:[Bx + 4h],Cx
              Mov       Word Ptr Es:[Bx + 6h],Dx
              Mov       Word Ptr Es:[Bx + 8h],Bp
              Mov       Word Ptr Es:[Bx + 10],Si
              Mov       Word Ptr Es:[Bx + 12],Di
              Mov       Word Ptr Es:[Bx + 14],Ds
              Pushf                                     ;Push the flags
              Pop       Ax                              ;Get them in Ax
              Mov       Word Ptr Es:[Bx + 18],Ax        ;Get Flag into pgm
              Pop       Ax                              ;Get Real Ax
              Mov       Word Ptr Es:[Bx + 16],Ax        ;Store it
              Add       Sp,4                            ;Remove Saved Regs
              Pop       Si
              Pop       Di
              Pop       Es
              Pop       Ds
              Add       Sp,IntLen
IFDEF POWERC
              Pop       Bp
ENDIF
              Ret
Intr          Endp
              End
            


