/**********************************************************/
/* Program Id.               Touch.C                      */
/* Author.                   Stan Milam.                  */
/* Date Written.             31 Aug. 89.                  */
/* Compiler.                 Mix Power C V1.3             */
/*                                                        */
/*          (c) Copyright 1989-90 by Stan Milam           */
/*                                                        */
/* Comments: This program is used to change file date and */
/* times.  This has applications for make utilities.      */
/**********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef __TURBOC__
#   include <io.h>
#   include <dir.h>
#   define  FA_NORMAL 0
#else
#   include <direct.h>
#endif
#include <dos.h>

/**********************************************************/
/*                      get_date_time()                   */
/*                                                        */
/* Get the system date & time from DOS and store in the   */
/* ftime structure.                                       */
/**********************************************************/

void get_date_time(struct ftime *f_time) {

     struct time d_time;               /* Structure for DOS time */
     struct date d_date;               /* Struct for Dos Date */

     getdate(&d_date);                 /* Get System Date */
     gettime(&d_time);                 /* Get System Time */
     f_time->ft_year = d_date.da_year - 1980;
     f_time->ft_month= d_date.da_mon;
     f_time->ft_day  = d_date.da_day;
     f_time->ft_hour = d_time.ti_hour;
     f_time->ft_min  = d_time.ti_min;
     f_time->ft_tsec = d_time.ti_sec / 2;
}

/**********************************************************/
/*                           Main                         */
/*                                                        */
/* 1. Initialize ftime structure.                         */
/* 2. Identify path specification                         */
/* 3. Get first file spec.                                */
/* 4. Repeat                                              */
/*      A. Build file name.                               */
/*      B. Open file and handle any errors.               */
/*      C. Set file time & date equal ftime structure     */
/*      D. Close file.                                    */
/*    Until no more matching files.                       */
/* 5. Clean up.                                           */
/**********************************************************/

int main(int argc, char *argv[]) {

    struct ftime f_time;
    struct ffblk fstruct;
    static char  wrkstr[80], *wrk;
    int    filecount = 0, lcv;
    FILE   *fp;

    puts("\nTOUCH version 1.00 by Stan Milam");
    if (argc < 2) {
       puts("Error:  No filespec\nFormat: TOUCH filespec filespec....");
       return(3);
    }
    get_date_time(&f_time);

/* Make TOUCH work with non-default drive and directories (with paths) */

    for (lcv = 1; lcv < argc; lcv++) {
        strcpy(wrkstr, argv[lcv]);
        if ((wrk = strrchr(wrkstr, '\\')) != NULL) wrk++;
        else {
           if ((wrk = strrchr(wrkstr,':')) != NULL) wrk++;
           else wrk = wrkstr;
        }
        if (findfirst(argv[lcv], &fstruct, FA_NORMAL) == 0) {
           printf("Touching %s\n",argv[lcv]);
           do {
              strcpy(wrk,fstruct.ff_name);
              fp = fopen(wrkstr, "r+b");
              if (fp == NULL) {
                 printf("Error touching file: (%s)\n",wrkstr);
              }
              else {
                 setftime(fileno(fp), &f_time);
                 fclose(fp);
                 filecount++;
             }
           } while (findnext(&fstruct) == 0);
       }
       else printf("(%s) *** No matching files ***\n", argv[lcv]);
    }
    printf("%d File(s) TOUCHED\n", filecount);
    return(0);
}
