/********************************************************************/
/*   SPAWNO v4.13  EMS/XMS/disk swapping replacement for spawn...() */
/*   (c) Copyright 1990,1991,1992 Ralf Brown  All Rights Reserved   */
/*								    */
/*   May be freely copied provided that this copyright notice is    */
/*   not altered or removed.					    */
/********************************************************************/

#include "_spawno.h"
#include <alloc.h>

int _Cdecl spawnlpeo(const char *overlay_path,const char *prog_name,...)
{
   char *prog_path = __spawn_search(prog_name) ;

   if (prog_path)
      {
      int retval ;
      va_list env ;

      va_start(env,prog_name) ;
      while (*((char **)env))  /* find NULL terminating list of program args */
	 va_arg(env,char *) ;
      va_arg(env,const char **) ; /* point at pointer to list of env variables */
      retval = __spawnv(overlay_path,prog_path,(const char **)_va_ptr,
			__spawn_buildenv(*((char ***)env))) ;
      va_end(env) ;
      __spawn_free_env() ;
      return retval ;
      }
   else
      {
      errno = ENOENT ;	/* not found-- _doserrno was set by __spawn_search() */
      return -1 ;
      }
}

