/****************************************************************************/
/*                                                                          */
/* START_1.C                                                                */
/*                                                                          */
/*     This C skeleton program was written to show you how to get up and    */
/* running quickly with the UltraWin library.  But first, allow me to       */
/* explain a little about the techniques we use.                            */
/*                                                                          */
/*     UltraWin was written with two "levels" in mind.  The first level     */
/* includes the routines that do all the down and dirty work of windowing.  */
/* This program is a demonstration showing how to use the lowest level      */
/* functions in an application.  The advantage to using this "first level"  */
/* layer is speed!  If you want the maximum speed, use this starter program */
/* as a "shell" to your application.                                        */
/*                                                                          */
/*     The second layer is what we call the window manager.  This is the    */
/* really slick part of UltraWin, as this provides capabilities to write    */
/* to any window at any time, regardless of overlap!  This layer is dealt   */
/* with in the START_2.C skeleton program.                                  */
/*                                                                          */
/*     The main thing to remember when using the "first level" style of     */
/* windowing is never mix the window manager routines with these routines,  */
/* unless you are absolutely sure you know what your are doing.  The        */
/* functions to stay away from when using the style used in this skeleton   */
/* are:                                                                     */
/*                                                                          */
/*                1)  add_window()                                          */
/*                2)  remove_window()                                       */
/*                2)  make_top_window()                                     */
/*                                                                          */
/* All other functions are ok to use.                                       */
/*                                                          Boyd Gafford    */
/*                                                          EnQue Software  */
/*                                                          12/18/90        */
/*                                                                          */
/****************************************************************************/
#include <ctype.h>
#include "uw.h"                           /* include the necessary headers  */
#include "uw_globx.h"
#include "uw_keys.h"


/*----------------------- global window variables --------------------------*/
WINDOW   Desk_window;                    /* global window for "desktop"     */
WINDOW   Pop_window;                     /* global POPUP window!            */


/*------------------------------ prototypes --------------------------------*/
void display_event( void );

/*********/
/* ~main */
/*       ********************************************************************/
/* This is the main routine, which does the simple skeleton demo!           */
/****************************************************************************/
int main()
{

  init_video(80, 50);

  /* This function initializes the window library, and sets the screen to   */
  /* 80 columns and 50 rows.  After the function call, the global variables */
  /* V_cols will contain the actual number of columns on the screen, and    */
  /* V_rows will contain the actual number of rows.  If you have a VGA      */
  /* board, you will get V_cols = 80 and V_rows = 50.  If you have an EGA   */
  /* board, you will get V_cols = 80 and V_rows = 43.  If you just have CGA */
  /* you will get V_cols = 80 and V_rows = 25.  If you wanted to use the    */
  /* 80x25 screen on ANY board, just use init_video(80, 25).                */

	init_clock(0x3333);

	/* This function takes over the PC clock, setting the timer interrupt to  */
	/* occur 91 times a second.  Once this call is made, you can use any of   */
	/* the UltraWin user timers, or the tone() function.  You do not have to  */
	/* call this if you are not going to use any of the UltraWin PC timer     */
	/* routines.                                                              */

	init_mouse();

  /* This will check for a mouse, and set the global Mouse_exists variable  */
  /* to 1 if one is found, or 0 if one is not.  To actually show the mouse, */
  /* you must call m_show after this function.                              */


  wn_create(0, 0, V_cols-1, V_rows-1, SLD_BDR, WN_POPUP, &Desk_window);

  /* This call will create a window equal to the size of the screen.        */


  wn_color(YELLOW, BLUE, &Desk_window);

  /* Set the color of the Desk_window to YELLOW text on a BLUE background.  */


  wn_bdr_color(WHITE, BLUE, &Desk_window);

  /* Set the border color of the Desk_window to WHITE on BLUE               */


  wn_name("[ Desktop Window ]", &Desk_window);

  /* Set the title of the back window to something kind of descriptive.     */

  wn_set(&Desk_window);

  /* Now, actually draw the window to the screen, saving what was below     */
  /* since the window was defined as a POPUP window when created!           */


  wn_plst(CENTERED, V_rows / 2, "Press a key or click the mouse!", &Desk_window);

  /* This just centers the message on line 2 of the Desk_window.  Note that */
  /* we use the special CENTERED define to replace the x-coord in the place */
  /* string output function.  We just as easily could have specified an xy  */
  /* pair, LEFT_JUST, or RIGHT_JUST to make string placement super easy!    */

  m_show();

  /* This shows the mouse on the screen!  Please note that a call to        */
  /* m_hide() before any of your window output routines is necessary to     */
  /* maintain screen integrity.  We chose to let you set when you show and  */
  /* hide the mouse rather than making it automatic, as calling hide and    */
  /* show after every output function possible is a little overkill and can */
  /* slow things down a little.                                             */

  wait_event();

  /* Just sit around and wait for either a mouse press or a key.  When the  */
  /* event occurs, the global Event variable will contain the key press     */
  /* information,  or mouse click information.                              */


  display_event();

  /* This is a function at the end of this skeleton file that demonstrates  */
  /* how to set a POPUP window on top of another window.  After the window  */
  /* is "popped up", the information in the global Event variable is shown, */
  /* and waits for another event while you look at it!                      */


  wn_plst(CENTERED, V_rows-5, "POPUP off now, area restored!", &Desk_window);
  m_show();
  wait_event();

  /* Display another message, and wait for an event before dropping to DOS. */


  wn_destroy(&Desk_window);

  /* this destroys the window you created, which means since it was defined */
  /* as a POPUP what was under it is restored.                              */

  m_hide();
  end_mouse();

  /* This routine tells UltraWin to turn off the mouse if present, and get  */
  /* ready to return to DOS.  If you don't call this function before you    */
  /* exit the program, you may find that your mouse will be active at the   */
  /* DOS prompt!                                                            */


  end_video();

  /* This cleans up and resets the video mode that was active when you      */
  /* first began the program.  Be sure to call this as the last function    */
	/* before you return to DOS!                                              */

  return(1);
}
/*** end of main ***/


/******************/
/* ~display_event */
/*                ***********************************************************/
/* Demo a popup window that displays the info in the Event global!          */
/****************************************************************************/
void display_event( void )
{
  int    width = 40;
  int    height = 15;
  int    x1 = (V_cols - width) / 2;
  int    y1 = (V_rows - height) / 2;
  int    x2 = x1 + width - 1;
  int    y2 = y1 + height - 1;

  /* Just a couple of calculations based on screen size to make wn_create   */
  /* look a little cleaner.  This sets a window in the middle of the screen */
  /* regardless of the number of rows (V_rows) we are working with!         */


  wn_create(x1, y1, x2, y2, SGL_BDR, WN_POPUP, &Pop_window);

  /* This call will create a little popup window centered in the screen.    */


  wn_color( WHITE, RED, &Pop_window);

  /* Set the color of the Pop_window                                        */


  wn_bdr_color( WHITE, RED, &Pop_window);

  /* Set the border color of the Pop_window                                 */


  wn_name("[ Event Contents ]", &Pop_window);

  /* Set the title of the little popup window to somthing descriptive.      */


  m_hide();

  /* Hide the mouse before we popup the window on the screen                */


  wn_set(&Pop_window);

  /* Now, actually draw the window to the screen, saving what was below     */
  /* since the window was defined as a POPUP window when created!           */


  if (Event.is_mouse)
  {
    wn_plst(CENTERED, 4, "Mouse Clicked!", &Pop_window);
    mv_cs(12, 7, &Pop_window);
    wn_printf(&Pop_window, "X = %d, Y = %d", Event.m_x, Event.m_y);
    mv_cs(9, 10, &Pop_window);
    switch(Event.m_button)
    {
      case LB: wn_st("Left Button Pressed", &Pop_window);   break;
      case MB: wn_st("Middle Button Pressed", &Pop_window); break;
      case RB: wn_st("Right Button Pressed", &Pop_window);   break;
    }
  } else
  {
    wn_plst(CENTERED, 5, "Key pressed!", &Pop_window);
    mv_cs(15, 9, &Pop_window);
    if (isalnum(Event.key))
      wn_printf(&Pop_window, "key = %c", Event.key);
    else
      wn_printf(&Pop_window, "key = 0x%02x", Event.key);
  }

  /* The above code simply displays the event information in the window!    */
  /* note the format for wn_printf.  Also note the use of the mv_cs()  macro*/
  /* to place the "window cursor" at the xy pair passed.  Any subsequent    */
  /* output, such as wn_st or wn_printf, occurs at that location            */


  m_show();
  /* Ok all the output we want to do before we wait for a key is done, so   */
  /* we can show the mouse on the screen again.                             */


  wait_event();

  /* Just sit around and wait for either a mouse press or a key.            */


  m_hide();

  /* Hide the mouse while we call wn_destroy to restore the POPUP.          */


  wn_destroy(&Pop_window);

  /* this destroys the window you created, which means since it was defined */
  /* as a POPUP what was under it is restored.                              */
}
/*** end of display_event ***/

/*** END OF FILE ***/
