/**
 ** RPN.H
 **
 ** The usual good h-file stuff for the rpn program.
 ** Global function prototypes, global variables, global defines.
 ** You know.
 **
 ** v3.0  90.05.08
 **	More stuff...
 ** v2.3  90.05.04
 **	fixed register-0 bug, ctrl-C hex-digit bug,
 **	added config. file for hex digits & display colors
 ** v2.2  90.01.23
 **	simplified stack display; Xreg in f format, others in e-format.
 ** v2.1  90.01.04  hrs() patch, screen positioning with SCROLL_LOCK
 ** v2.0  90.01.01
 **	hr.minsec <-> decimal hours, percent, precomputed screens,
 **	exponent input, degrees mode, "doco" updates, TC v2.0
 **/
#ifndef RPN_H
#define RPN_H

#ifdef __TURBOC__
#define C_DECL cdecl
#else
#define C_DECL
#endif

#include <stdio.h>
#include <values.h>     /**  Supplies MAXLONG, MAXDOUBLE ...  **/

int  process(int);
void init_machine(void);

void toggle_help(void);
void startup(void);
void shutdown(void);

int  getkey(void);
void open_savefile(const char *);
void close_savefile(void);


#define TRUE      1
#define FALSE     0
#define DEGREES  'D'
#define RADIANS  'R'

#define OK_VAL    0	/* Possible return values of the process() ftn. */
#define INIT_VAL  1
#define QUIT_VAL  2
#define ABORT_VAL 3
#define NO_CHANGE 4

#define NAME_LEN  14    /** function-display fields are 13 chars wide **/

#define MAX_BASE  16    /** biggest possible displayed-number base **/

#ifdef MAIN
const char version[] = "RPN 3.0 / " __DATE__  " ";

#include <dos.h>
#include "digits.h"	/** define the array of acceptable digits.	**/

/*
| Names and default values of display-window colors.
*/
char	filename[13];		/** Keep savefile name for shell re-use **/
char	default_save[] = "save-out.rpn";	/** save-file name	**/
FILE	*savefile = NULL;
int	write_save = FALSE;

int    TOP =   6;		/** default values for upper-left pos'n **/
int    LEFT = 41;		/**   of the display window (v2.0)      **/
unsigned D_BKGND, D_BORDER, D_NUM, D_FTN, D_OOPS;  /** display colors	**/

char   xbuf[40], *xbp = xbuf;		/** ASCII form of number inputs **/
double lastx, xreg, yreg, zreg, treg;	/** RPN stack registers		**/
char   thisfunct[NAME_LEN];		/** current-function display	**/
char   lastfunct[NAME_LEN];		/** last-function display	**/
int    notation, base, pre, negative;
int    help_flag = 0;		/** Which Help screen?  0 => none	**/
int    trig_mode = DEGREES;	/** Angle-mode flag; default to degrees **/
int    newnum;			/** "Is this the first digit entered?"  **/
int    num_ct;			/** number of fractional digits		**/

char orig_sl;			/** save orignal scrl status as "off"	**/
char scrolllock;		/** flag for scroll-lock status **/
volatile void far *ksp = MK_FP(0x0000, 0x0417);

#else	/* !MAIN */

extern const char  version[];
extern char	default_save[];		/** save-file name	**/
extern char	filename[13];
extern FILE	*savefile;
extern int	write_save;

extern int	TOP, LEFT;	/** display-window upper left corner **/
extern unsigned D_BKGND, D_BORDER, D_NUM, D_FTN, D_OOPS;

extern char	xbuf[40], *xbp;	/** ASCII form of number inputs **/
extern double	lastx, xreg, yreg, zreg, treg;
extern char	thisfunct[NAME_LEN];
extern char	lastfunct[NAME_LEN];
extern int	notation, base, pre, negative;
extern unsigned digits[MAX_BASE];
extern int	help_flag;
extern int	trig_mode;
extern int	newnum;		/** "Is this the first digit entered?" **/
extern int	num_ct;		/** number of fractional digits **/
extern char	orig_sl;	/** save orignal scrl status as "off"	**/
extern char	scrolllock;
volatile extern void far *ksp;

#endif	/* MAIN */

#endif	/* RPN_H */
