; File......: NWTTS5.ASM
; Author....: James R. Zack
; CIS ID....: 75410,1567
; Date......: $Date:   15 Aug 1991 23:07:06  $
; Revision..: $Revision:   1.2  $
; Log file..: $Logfile:   E:/nanfor/src/nwtts5.asv  $
; 
; This is an original work by James Zack and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
; $Log:   E:/nanfor/src/nwtts5.asv  $
;  
;     Rev 1.2   15 Aug 1991 23:07:06   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;  
;     Rev 1.1   14 Jun 1991 19:54:50   GLENN
;  Minor edit to file header
;  
;     Rev 1.0   01 Apr 1991 01:03:44   GLENN
;  Nanforum Toolkit
;  

; $DOC$
; $FUNCNAME$
;     FT_TTSSTAT()
; $CATEGORY$
;     NetWare
; $ONELINER$
;     Verify if TTS transaction has been written to disk
; $SYNTAX$
;    FT_TTSSTAT( <nTransNumber> ) -> nResult
; $ARGUMENTS$
;    <nTransNumber> is the transaction number, returned from FT_TTSEND().
; $RETURNS$
;      0 - Success, transaction written to disk
;    255 - Transaction not yet written to disk
; $DESCRIPTION$
;    For further information on NetWare's Transaction Tracking System (TTS),
;    consult Novell's documentation.
; $EXAMPLES$
;    nResult := FT_TTSSTAT()
;    DO CASE
;       CASE nResult == 0
;          ? "Transaction wrttten to disk"
;       CASE nResult == 255
;          ? "Transaction not yet written to disk"
;       OTHERWISE
;          ? "Unknown result code"
;    ENDCASE
; $SEEALSO$
;    FT_TTSABORT() FT_TTSAVAIL() FT_TTSBEGIN() FT_TTSEND()
; $END$

PUBLIC    FT_TTSSTAT
EXTRN     __PARNL:FAR
EXTRN     __RETNI:FAR
EXTRN     __RET:FAR
_NanFor   SEGMENT 'CODE'
          ASSUME cs:_NanFor
FT_TTSSTAT  PROC    FAR
          push    bp
          mov     bp,sp
          push    ds
          push    es
          push    si
          push    di
          mov     ax,1
          push    ax
          call    __PARNL
          add     sp,2
          mov     cx,dx
          mov     dx,ax
          mov     ah,0c7h          ; Novell API function c7
          mov     al,04h           ; Subfunction 02
          int     21h              ; TTS Transaction Status
          mov     ah,00h
          push    ax
          call    __RETNI
          add     sp,2
          pop     di
          pop     si
          pop     es
          pop     ds
          pop     bp
          call    __RET
          ret

FT_TTSSTAT  endp

_NanFor   ends

          end

