* Function: GETPARM
* Author..: Richard Low
* Syntax..: GETPARM( number, string )
* Returns.: Specified portion of the given string, starting at the number-1
*           comma until the next comma, or end of string.
*           if no parameter is given or is an invalid type.

FUNCTION GETPARM
PARAMETERS p_number, p_string
PRIVATE f_string

*-- make sure a parameters are correct
IF TYPE('p_number') + TYPE('p_string') != 'NC'
   RETURN ('')
ENDIF

*-- make working copy to ensure original parmater is not touched
f_string = p_string

*-- find the text following the (nth - 1) comma if any
FOR x = 1 TO p_number - 1
   *-- strip off text preceding the comma
   f_string = TRIM( SUBSTR(f_string, AT(",",f_string) + 1 ) )
NEXT x

*-- if there is a comma in the string
IF AT(",",f_string) > 0
   *-- if it's the 1st character
   IF SUBSTR(f_string,1,1) = ","
      *-- return nothing
      RETURN ('')
   ELSE
      *-- return everything up to the comma
      RETURN (SUBSTR(f_string, 1, AT(",",f_string)-1 ))
   ENDIF
ELSE
   *-- if no comma, just return the string itself
   RETURN (f_string)
ENDIF

RETURN ('')
