* Function: PICKFILE
* Author..: Richard Low
* Syntax..: PICKFILE( [filespec [,top, left, bottom [,colors [,expanded ]]]] )
* Returns.: Filename picked from a boxed directory listing.
*

FUNCTION PICKFILE
PARAMETERS p_filespec, p_trow, p_tcol, p_brow, p_colors, p_expanded
PRIVATE f_elements, f_bcol, f_pick, f_incolor

*-- if no filespec given or it is empty, default to all files
p_filespec = IF( TYPE('p_filespec') = 'C',;
             IF( EMPTY(p_filespec), '*.*', p_filespec ), '*.*' )

*-- default mode is wide display
p_expanded = IF( TYPE('p_expanded') = 'L', p_expanded, .T. )

*-- if all three <top left bottom> cordinates are not numeric
IF TYPE('p_trow') + TYPE('p_tcol') + TYPE('p_brow') != 'NNN'
   *-- center the display in the middle of the screen
   p_trow =  6
   p_brow = 19
   *-- width of display (including box) is 43 if expanded, 14 otherwise
   p_tcol = (80 - IF(p_expanded,43,14)) / 2
ELSE
   *-- make sure top row is within screen limits
   p_trow = IF( p_trow < 0 .OR. p_trow > 20, 6, p_trow )

   *-- make sure window will fit given top column, adjust left if needed
   p_tcol = IF( p_tcol > IF(p_expanded,38,67), IF(p_expanded,38,67), p_tcol )

   *-- make sure bottom row is greater than top row
   p_brow = IF( p_brow < p_trow+2 .OR. p_brow > 24, 20, p_brow )
ENDIF

*-- if color not specified or is empty, use the current color
p_colors = IF( TYPE('p_colors') = 'C',;
           IF( EMPTY(p_colors), SETCOLOR(), p_colors ), SETCOLOR() )

*-- get the number of files matching <filespec>
p_filespec = TRIM(p_filespec)
f_elements = ADIR(p_filespec)

IF f_elements = 0
   SAYINBOX( 'No files found matching ', p_filespec, 5 )
   RETURN ''
ENDIF

DECLARE dirlist[f_elements]                                      && set up array to hold list of filenames
IF p_expanded
   DECLARE size[f_elements], date[f_elements], time[f_elements]
   ADIR( p_filespec, dirlist, size, date, time )                 && fill array with filenames
   FOR x = 1 TO LEN(dirlist)                                     && if including extension
      dirlist[x] = SUBSTR(dirlist[x] + SPACE(12),1,12) +;
                   TRANSFORM(size[x],'  ##,###,###  ') +;
                   DTOC(date[x]) + '  ' +;
                   SUBSTR(time[x],1,5)                           && make all names 12 characters long
   NEXT x                                                        && (pad with trailing spaces if needed)
ELSE
   ADIR( p_filespec, dirlist )                                   && fill array with filenames
   FOR x = 1 TO LEN(dirlist)                                     && if including extension
      dirlist[x] = SUBSTR(dirlist[x] + SPACE(12),1,12)
   NEXT x                                                        && (pad with trailing spaces if needed)
ENDIF

p_brow = IF( f_elements < (p_brow - p_trow), p_trow + f_elements + 1, p_brow )
f_bcol = p_tcol + IF(p_expanded,41,12) + 1

f_window = SAVESCREEN( p_trow, p_tcol, p_brow, f_bcol )

f_incolor = SETCOLOR(p_colors)
@ p_trow, p_tcol, p_brow, f_bcol BOX 'ͻȺ'

f_pick = ACHOICE( p_trow+1, p_tcol+1, p_brow-1, f_bcol-1, dirlist )

RESTSCREEN( p_trow, p_tcol, p_brow, f_bcol, f_window )
SETCOLOR(f_incolor)

RETURN IF( f_pick = 0, '', TRIM(SUBSTR(dirlist[f_pick],1,12)) )
