///////////////////////////////////////////////////////////////////////////
//                                                                       //
//            File: Kbd.cpp                                              //
//            started on: 28/7/93                                        //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  KBD allows you to hook a hotkey. Just pass the constructor your      //
//  hotkey specifications and the hotkey function will be called         //
//  whenever that hotkey is pressed.                                     //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//                    by Ofer Laor (AKA LeucroTTA)                       //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#include "kbd.h"; // KBD.
#include <dos.h>; // inportb, outportb, MK_FP.

// constructor remembers hotkey params.
KBD::KBD(unsigned char scan_code, unsigned char controls, int kill_key)

{
    // remember hotkey params.
    bScanCode= scan_code;
    bControls= controls;
    fKillKey= kill_key;

    // set shift state pointer to it's bios location.
    pShift= (unsigned char far *)MK_FP(0, 0x417);

    // hook into keyboard.
    activate(0x9);
}

// keyboard interrupt routine. Check for hotkey. Call hotkey func. Swallow
// key if fKillKey is active.
void KBD::isr()
{
    unsigned char scan= inportb(0x60);   // get key.
    unsigned char ctrl= *pShift& 0xf;    // ignore high states (insert state, etc.).

    // except for Shifts (which are ORed), control states are ANDed.

    // scan code && shift state.
    if ((bControls== (bControls& ctrl)) ||
       (((bControls& KBS_SHIFT)== KBS_SHIFT) && (ctrl& KBS_SHIFT)))
       if (scan== bScanCode) {

          if (kill_key()) {

             // swallow key.

             unsigned char old_state= inportb(0x61);
             outportb(0x61, old_state& 0x80);
             outportb(0x61, old_state);

             // eoi.
             outportb (0x20, 0x20);
             hotkey();

             return;
          }

          else
            hotkey(); // run hotkey without swallowing the key.
    }

    // hook back interrupt.
    old_vect();
}
