//--------------------------------------------------------------------------
//
//      EXAMPLE2.CPP: example for DOS multithreading library.
//      Copyright (c) J.English 1993.
//      Author's address: je@unix.brighton.ac.uk
//
//      Permission is granted to use copy and distribute the
//      information contained in this file provided that this
//      copyright notice is retained intact and that any software
//      or other document incorporating this file or parts thereof
//      makes the source code for the library of which this file
//      is a part freely available.
//
//--------------------------------------------------------------------------
//
//      This example starts 3 threads, each of which repeatedly displays
//      a message and then delays for either 3, 5 or 7 seconds.
//
//--------------------------------------------------------------------------

#include <stdio.h>
#include <conio.h>
#include "threads.h"

class Example2 : public DOSThread
{
  public:
    Example2 (int n, int s)      { num = n; secs = s; }

  protected:
    virtual void main ();

  private:
    int num;
    int secs;
};

void Example2::main ()
{
    char c [70];
    sprintf (c, "Starting thread %d, %d second delays\n", num, secs);
    fputs (c, stdout);
    sprintf (c, "Thread %d\n", num);
    while (!userbreak ())
    {   fputs (c, stdout);
        delay (secs * 18);      // 1 second = 18 clock ticks (approx.)
    }
    sprintf (c, "End of thread %d\n", num);
    fputs (c, stdout);
}

void main ()
{
    Example2 e1 (1, 3);
    Example2 e2 (2, 5);
    Example2 e3 (3, 7);

    puts ("Press CONTROL-BREAK to terminate");
    puts ("Press any key to start...");
    getch ();

    if (!e1.run ())
        puts ("Couldn't start thread 1");
    if (!e2.run ())
        puts ("Couldn't start thread 2");
    if (!e3.run ())
        puts ("Couldn't start thread 3");
}
