
; control register & bit definition
;       assumes operating mode 2 or 3

p1ddr   equ     0       ; port 1 data direction
p2ddr   equ     01      ; port 2 data direction
p1dr    equ     02      ; port 1 data
p2dr    equ     03      ; port 2 data

p2d_pc2     equ     080
p2d_pc1     equ     040
p2d_pc0     equ     020
p2d_p24     equ     010
scixmt      equ     p2d_p24
p2d_p23     equ     08
scircv      equ     p2d_p23
p2d_p22     equ     04
sciclock    equ     p2d_p22
p2d_p21     equ     02
timerout    equ     p2d_p21
p2d_p20     equ     01
timerin     equ     p2d_p20

tcsr    equ     08      ; timer control & status

tcs_icf     equ     080     ; input capture flag
tcs_ocf     equ     040     ; output capture flag
tcs_tof     equ     020     ; timer overflow flag
tcs_eici    equ     010     ; enable input capture interrupt
tcs_eoci    equ     08      ; enable output capture flag
tcs_etoi    equ     04      ; enable timer overflow interrupt
tcs_iedg    equ     02      ; input edge
tcs_olvl    equ     01      ; output level

counth  equ     09      ; timer counter msb
countl  equ     0a      ; timer counter lsb
outcmh  equ     0b      ; timer output compare msb
outcml  equ     0c      ; timer output compare lsb
incaph  equ     0d      ; input capture msb
incapl  equ     0e      ; input capture lsb
rmcr    equ     010     ; SCI rate & mode control

rmc_cc1     equ     08
rmc_cc0     equ     04
rmc_cc      equ     0c      ; clock source and format
rmc_ss1     equ     02
rmc_ss0     equ     01
rmc_ss      equ     03      ; clock speed select 0-3, hi-lo

trcsr   equ     011     ; xmit/rcv control & status

trc_rdf     equ     080     ; rcv data reg full
trc_ofe     equ     040     ; overrun or framing error
trc_tre     equ     020     ; xmit data reg empty
trc_rie     equ     010     ; rcv interrupt enable
trc_re      equ     08      ; receiver enable
trc_tie     equ     04      ; xmit interrupt enable
trc_te      equ     02      ; transmitter enable
trc_wu      equ     01      ; wakeup

scirdr  equ     012     ; SCI rcv data
scitdr  equ     013     ; SCI xmit data
ramcr   equ     014     ; RAM control

ram_sb      equ     080     ; stand-by power
ram_e       equ     040     ; internal RAM enabled

stintram equ    080
enintram equ    0ff

; interrupt vectors

vectors equ     0ff0
scivec  equ     vectors+0
tofvec  equ     vectors+02
tocvec  equ     vectors+04
ticvec  equ     vectors+06
rq1vec  equ     vectors+08
swivec  equ     vectors+0a
nmivec  equ     vectors+0c
startvec equ    vectors+0e
