Listing 2


USE Benchmark
go
drop procedure AG_XACT4
go
CREATE PROCEDURE AG_XACT4 (
      /*-------------------------------------------*/
      /*                                           */
      /*      TRANSACTION 4: Address Change        */
      /*                                           */
      /*-------------------------------------------*/

   @FirstName varchar(12) = NULL,
   @LastName  varchar(12) = NULL,
   @LineOne   varchar(32) = NULL,
   @LineTwo   varchar(32) = NULL,
   @City      varchar(32) = NULL,
   @State     varchar(3)  = NULL,
   @Zipcode   varchar(9)  = NULL)

AS BEGIN
   DECLARE
      @AddressID  int,
      @Country   varchar(3),
      @OldAddress int,
      @PersonID   int,
      @SubAddress int

   SELECT @Country = 'USA'

    /*-----------------------------------------*/
    /* Conversion of blank strings to NULL's   */
    /*-----------------------------------------*/

    IF (@FirstName = '')
      SELECT @FirstName = NULL

    IF (@LastName = '')
      SELECT @LastName = NULL

    IF (@LineOne = '')
      SELECT @LineOne = NULL

    IF (@LineTwo = '')
      SELECT @LineTwo = NULL

    IF (@City = '')
      SELECT @City = NULL

    IF (@State = '')
      SELECT @State = NULL

    IF (@Zipcode = '')
      SELECT @Zipcode = NULL

     /*------------------------*/
     /* Get a new AddressID    */
     /*------------------------*/

    BEGIN TRANSACTION

      UPDATE Seqnos
      SET    LastUsed = LastUsed + 1
      WHERE  TableName = 'Addresses'

      SELECT @AddressID = LastUsed
      FROM   Seqnos
      WHERE  TableName = 'Addresses'

   COMMIT TRANSACTION

     /*------------------------*/
     /*  Zipcode Verification  */
     /*------------------------*/

   BEGIN TRANSACTION
   IF @Zipcode IS NOT NULL
      IF NOT EXISTS (SELECT *
                       FROM  ZipCodes
                      WHERE  Country = @Country
                        AND  ZipCode = @Zipcode)
      BEGIN
         ROLLBACK TRANSACTION
         RAISERROR 20401 "Invalid Zipcode."
         RETURN
      END

    /*------------------*/
    /*  Insert Address  */
    /*------------------*/

     INSERT INTO Addresses (ID,LineOne,LineTwo,ZipCode,Country)
     VALUES (@AddressID,@LineOne,@LineTwo,@Zipcode,@Country)

      IF @@ROWCOUNT = 0
         BEGIN
           SELECT @AddressID = ID
             FROM Addresses
            WHERE LineOne = @LineOne
              AND  ((LineTwo = @LineTwo) OR (LineTwo IS NULL))
              AND  ZipCode = @Zipcode

           IF @@ROWCOUNT = 0
             BEGIN
               ROLLBACK TRANSACTION
               RAISERROR 20402 "Insert Addresses failed."
               RETURN
             END
         END

     /*-----------------------*/
     /*  Look up old address  */
     /*-----------------------*/

     SELECT @PersonID = ID,@OldAddress = HomeAddr
     FROM   People
     WHERE  LastName = @LastName AND FirstName = @FirstName

     IF @@ROWCOUNT = 0
       BEGIN
         ROLLBACK TRANSACTION
         RAISERROR 20403 "Person not found."
         RETURN
       END

    /*----------*/
    /* Move it. */
    /*----------*/

     UPDATE People
     SET   HomeAddr = @AddressID
     WHERE  ID    = @PersonID

     IF @@ROWCOUNT = 0
       BEGIN
         ROLLBACK TRANSACTION
         RAISERROR 20404 "Updating People failed."
         RETURN
       END

     COMMIT TRANSACTION

    /*----------------------------------*/
    /* See if we can delete the old one */
    /*----------------------------------*/

   IF @OldAddress IS NOT NULL
     BEGIN
       BEGIN TRANSACTION

         DELETE FROM Addresses
         WHERE  ID = @OldAddress
         AND    NOT EXISTS (SELECT *
                            FROM People
                            WHERE HomeAddr = @OldAddress)
         AND    NOT EXISTS (SELECT *
                            FROM Companies
                            WHERE HQaddr = @OldAddress)
         AND    NOT EXISTS (SELECT *
                            FROM CompanyPeople
                            WHERE WorkAddr = @OldAddress)
         AND    NOT EXISTS (SELECT *
                            FROM Subscriptions
                            WHERE Address = @OldAddress)
     COMMIT TRANSACTION
   END
END
go
GRANT ALL ON AG_XACT4 TO PUBLIC
go
