Listing 4


#include "sqlssp.h"

DBINT SQLCODE;
long  RowsFetched;
RETCODE  RetCode;
extern long input[];


void Xact20(USHORT usLevel,USHORT usGroup,FILE *df,DBPROCESS *dbproc)
{
   struct DataFileRecord20 DFR;

   DBCHAR LCatalogID[17];
   DBCHAR LQuantity[9];
   DBCHAR LPrice[9];
   DBCHAR LDate[9];

   if (fread((char *) &DFR,sizeof(DFR),1,df) > 0) {
      input[20]++;

      strncpy(LCatalogID, DFR.CatalogID, 16);
      strtrim(LCatalogID, 17);

      strncpy(LQuantity, DFR.Quantity, 8);
      strtrim(LQuantity, 9);

      strncpy(LPrice, DFR.Price, 8);
      strtrim(LPrice, 9);

      strncpy(LDate, DFR.Date, 8);
      strtrim(LDate, 9);

#if defined (DEBUG)
      printf ("\n\nTransaction 20 - Update Price [%ld]\n\n",input[20]);
      printf ("CatalogID :%s:\n",LCatalogID);
      printf ("Quantity  :%s:\n",LQuantity);
      printf ("Price     :%s:\n",LPrice);
      printf ("Date      :%s:\n\n",LDate);
#endif

/*--------------------------------------------------------
|
|   TRANSACTION 20: Update Price
|
--------------------------------------------------------*/
      SetStartTime();
      SQLCODE = dbfcmd(dbproc,"EXECUTE AG_XACT20 @CatalogID=\"%s\","
	      "@Date=\"%s\",@Price=$%s,@Quantity=%s",
	      LCatalogID,LDate,LPrice,LQuantity);

      if ((SQLCODE = dbsqlexec(dbproc)) == SUCCEED)
         SQLCODE = dbresults(dbproc);
      if (SQLCODE != CODE_SUCCEED) {
	 SetEndTime(usLevel,20,usGroup,0L);
	 return;
      }
      SetEndTime(usLevel,20,usGroup,1L);
   }
}
