; File: BRIE.LIB

(PUTD 'DEFUN '(NLAMBDA (NAM$ EXP$) (PUTD NAM$ EXP$) NAM$))



(DEFUN * (NLAMBDA X
  NIL ))

(DEFUN CONCAT (LAMBDA (P Q)
  (* concatonate 2 lists together *)
  ((NULL P) Q)
  (CONS (CAR P) (CONCAT (CDR P) Q)) ))

(DEFUN PURGE (LAMBDA (L)
  (* purge a list of duplicate members *)
  ((NULL L) NIL)
  ((MEMBER (CAR L) (CDR L))
    (PURGE (CDR L)) )
  (CONS (CAR L) (PURGE (CDR L))) ))

(DEFUN JOIN (LAMBDA (L M)
  (* form the set union of 2 lists *)
  (PURGE (CONCAT L M)) ))

(DEFUN MEET (LAMBDA (L M)
  (* form the set intersection of 2 lists *)
  (PURGE (COMMON L M)) ))

(DEFUN COMMON (LAMBDA (L M)
  (* form the set intersection of 2 lists with possible
      duplicate entries *)
  ((NULL L) NIL)
  ((MEMBER (CAR L) M)
    (CONS (CAR L) (COMMON (CDR L) M)) )
  (COMMON (CDR L) M) ))

(DEFUN DEF (LAMBDA (V E)
  (* determine whether the variable V is defined in the
      environment E *)
  ((NULL E) NIL)
  ((EQUAL V (CAAR E)) T)
  (DEF V (CDR E)) ))

(DEFUN IMM (LAMBDA (V E)
  (* return the immeadiate successor of the variable V in the
      environment E *)
  ((NULL E) NIL)
  ((EQUAL V (CAAR E))
    (CDAR E) )
  (IMM V (CDR E)) ))

(DEFUN ULT (LAMBDA (V E)
  (* return the ultimate successor of the variable V in the
      environment E *)
  ((DEF V E)
    (ULT (IMM V E) E) )
  V ))

(DEFUN PAIRP (LAMBDA (P)
  (* determine if P is a pair (not an atom) *)
  ((ATOM P) NIL)
  T ))

(DEFUN VARIABLEP (LAMBDA (V)
  (* determine if V is a variable *)
  (EQ (CAR (UNPACK V)) '*) ))

(DEFUN RECREAL (LAMBDA (F E)
  (* return the recursive realization of a formula F in the
      environment E which amounts to instantiating all variables
      from the environment *)
  ((PAIRP F)
    (CONS (RECREAL (CAR F) E) (RECREAL (CDR F) E)) )
  ((DEF F E)
    (RECREAL (ULT F E) E) )
  F ))

(DEFUN OCCURS (LAMBDA (V X E)
  (* see if the variable V occurs in the term X under the
      environment E *)
  ((VARIABLEP X)
    ((DEF X E)
      (OCCURS V (IMM X E) E) )
    ((EQ V X) T) )
  ((ATOM X) NIL)
  ((OCCURS V (CAR X) E) T)
  (OCCURS V (CDR X) E) ))

(DEFUN UNIFY (LAMBDA (A B E)
  (* unify 2 expressions (A and B) in the environment E by
      extending E to the most general unifier of A and B and
      returning that environment *)
  ((EQ E 'IMPOSSIBLE)
    'IMPOSSIBLE )
  (EQUATE (ULT A E) (ULT B E) E) ))

(DEFUN EQUATE (LAMBDA (A B E)
  (* auxilliary routine to UNIFY so that the flow of control
      ping-pongs recursivly between UNIFY and EQUATE to
      construct the most general unifier of A and B *)
  ((EQUAL A B) E)
  ((VARIABLEP A)
    ((OCCURS A B E)
      'IMPOSSIBLE )
    (CONS (CONS A B) E) )
  ((VARIABLEP B)
    ((OCCURS B A E)
      'IMPOSSIBLE )
    (CONS (CONS B A) E) )
  ((ATOM A)
    'IMPOSSIBLE )
  ((ATOM B)
    'IMPOSSIBLE )
  (UNIFY (CDR A) (CDR B) (UNIFY (CAR A) (CAR B) E)) ))

(DEFUN VARS (LAMBDA (X)
  (* return a list of all the variables found in the expression
      X *)
  ((NULL X) NIL)
  ((VARIABLEP X) X)
  ((ATOM X) NIL)
  (CONCAT (VARS (CAR X)) (VARS (CDR X))) ))

(DEFUN VARIANT (LAMBDA (Q E D)
  (* returns a variant of D such that all variables are distinct
      from those of Q in the environment E *)
  (RECREAL D (MAKENV (VARS Q) (VARS E) (VARS D))) ))

(DEFUN MAKENV (LAMBDA (Q E D)
  (* make an environment such that the instantiation of D in
      this environment will have no variables in common with the
      instantiation of Q in E *)
  (MAKENV1 (MEET D (JOIN Q E)) (JOIN (JOIN Q E) D)) ))

(DEFUN MAKENV1 (LAMBDA (P Q V)
  (* does the dirty work for MAKENV and VARIANT by generating an
      environment that sticks asterisks onto the front of all
      variable names in Q that also occur in P (V is a local
      temporary variable) *)
  ((NULL P) NIL)
  ((ATOM P)
    (SETQ V P)
    (LOOP
      ((NOT (MEMBER V Q)))
      (SETQ V (PACK (CONS '* (UNPACK V)))) )
    (CONS P V) )
  (CONS (MAKENV1 (CAR P) Q) (MAKENV1 (CDR P) Q)) ))

(DEFUN GETLIT (LAMBDA (CL N)
  (* get the Nth litteral in the clause CL and return it both as
      the functions value and in the free variable LITG along
      with its sign in the free variable SIGNG *)
  (SETQ LITG (CAR (NTH CL N)))
  (SETQ SIGNG (NOT (EQ (CAR LITG) '~)))
  ((NOT (NULL SIGNG)) LITG)
  (CADR LITG) ))

(DEFUN FRONT (LAMBDA (C N)
  (* return all elements in the clause C in front of element N
      *)
  ((NULL C) NIL)
  ((ZEROP N) NIL)
  ((EQ N 1) NIL)
  (CONS (CAR C) (FRONT (CDR C) (SUB1 N))) ))

(DEFUN BACK (LAMBDA (C N)
  (* return all elements in clause C in back of element N *)
  (NTH C (ADD1 N)) ))

(DEFUN FACTOR (LAMBDA (C P1 N1 S1 P2 N2 S2 ENV)
  (* returns a factored version of the clause C *)
  (SETQ ENV 'IMPOSSIBLE)
  (SETQ N1 0)
  (LOOP
    (SETQ N1 (ADD1 N1))
    ((GREATERP N1 (LENGTH C))
      'IMPOSSIBLE )
    (GETLIT C N1)
    (SETQ P1 LITG)
    (SETQ S1 SIGNG)
    (SETQ N2 N1)
    ( ((LOOP
          (SETQ N2 (ADD1 N2))
          ((GREATERP N2 (LENGTH C)))
          (GETLIT C N2)
          (SETQ P2 LITG)
          (SETQ S2 SIGNG)
          ( ((EQ S1 S2)
              (SETQ ENV (UNIFY P1 P2)) ) )
          ((NOT (EQ ENV 'IMPOSSIBLE))
            (SETQ C (RECREAL C ENV))
            (SETQ C (APPEND (FRONT C N1) (BACK C N1))) ) )) )
    ((NOT (EQ ENV 'IMPOSSIBLE))) )
  ((NOT (EQ ENV 'IMPOSSIBLE)) C)
  'IMPOSSIBLE ))

(DEFUN BINRES (LAMBDA (CL1 N1 CL2 N2 ENV LIT1 SGN1 LIT2 SGN2 L1
    L2 LITG SIGNG)
  (* compute the binary resolvent of clause CL1 litteral number
      N1 with clause CL2 litteral number N2 and return the
      instantiated resolvent *)
  (SETQ CL2 (VARIANT CL1 ENV CL2))
  (SETQ LIT1 (GETLIT CL1 N1))
  (SETQ L1 LITG)
  (SETQ SGN1 SIGNG)
  (SETQ LIT2 (GETLIT CL2 N2))
  (SETQ L2 LITG)
  (SETQ SGN2 SIGNG)
  ((EQ SGN1 SGN2) NIL)
  (SETQ ENV (UNIFY LIT1 LIT2 ENV))
  ((EQ ENV 'IMPOSSIBLE)
    'IMPOSSIBLE )
  (RECREAL (APPEND (FRONT CL1 N1) (BACK CL1 N1) (FRONT CL2 N2)
      (BACK CL2 N2)) ENV) ))

(DEFUN PARAMOD (LAMBDA (FROM INTO PF F PI I SEL SUB ENV SWAP PM)
  (* return the paramodulant of the FROM clause into the INTO
      clause *)
  (SETQ INTO (VARIANT FROM NIL INTO))
  (SETQ PM 'IMPOSSIBLE)
  (SETQ PF 0)
  (LOOP
    (SETQ PF (ADD1 PF))
    (SETQ F (CAR (NTH FROM PF)))
    ((NULL F))
    ((EQ (CAR F) '=)
      (SETQ SEL (CADR F))
      (SETQ SUB (CADDR F))
      (SETQ PI 0)
      (LOOP
        (SETQ PI (ADD1 PI))
        (SETQ I (CAR (NTH INTO PI)))
        ((NULL I))
        (SETQ ENV (UNIFY SEL I))
        ( ((EQ ENV 'IMPOSSIBLE)
            (SETQ ENV (UNIFY SUB I))
            (SETQ SUB SEL) ) )
        ((NOT (EQ ENV 'IMPOSSIBLE))
          (SETQ FROM (RECREAL FROM ENV))
          (SETQ INTO (RECREAL INTO ENV))
          ( ((NOT (NULL SWAP))
              (SETQ SUB SEL) ) )
          (SETQ INTO (APPEND (FRONT INTO PI) (LIST SUB) (BACK
              INTO PI)))
          (SETQ FROM (APPEND (FRONT FROM PF) (BACK FROM PF)))
          (SETQ PM (APPEND FROM INTO)) ) ) )
    ((NOT (EQ PM 'IMPOSSIBLE))) )
  PM ))

(RDS)
 FROM PF) (BACK FROM PF)))
          (SETQ PM (APPEND FROM INTO)) ) ) )
    ((NOT (EQ PM 'IMPOSSIBLE))) )
  PM 