
Listing 1:  BASIC source code for the Sieve benchmark

1000 ' Sieve Benchmark Test
1001 ' Version 1.0  5/30/86  Namir C. Shammas
1010 DEFINT A-Z
1020 SIZE = 7000
1030 MAXITER = 10
1040 TRUE = 1: FALSE = 0
1050 DIM  FLAGS(SIZE)
1060 PRINT "START ";MAXITER;" ITERATION"
1065 TIME$ = "00:00:00.00"
1070 FOR ITER = 1 TO MAXITER
1080    COUNT = 0
1090    FOR I = 0 TO SIZE
1100      FLAGS(I) = TRUE
1110    NEXT I
1120    FOR I = 0 TO SIZE
1130      IF FLAGS(I) <> TRUE THEN 1210
1140        PRIME = I+I+3
1150        K = I+PRIME
1160        WHILE K <= SIZE  
1170           FLAGS(K) = FALSE
1180           K = K + PRIME 
1190        WEND 
1200        COUNT = COUNT + 1
1210    NEXT I 
1220 NEXT ITER
1225 PRINT "Time is ";TIME$
1230 PRINT COUNT;" PRIMES"
1240 END 




Listing 2: Translated C source code for the Sieve benchmark

char *TIME_(), *balloc(); 
static int *FLAGS, count, false, i, iter, k, maxiter, prime, size, true; 
static int it_1, it_2, it_3; 
static char *st_1; 
static int ml_1; 
main(argc, argv) 
    int argc; 
    char *argv[]; 
    { 
    bio_init(argc, argv, 1); 
    /* Sieve Benchmark Test */
    /* Version 1.0  5/30/86  Namir C. Shammas */
    size = 7000; 
    maxiter = 10; 
    true = 1; 
    false = 0; 
    ml_1 = size+1; 
    bfree(FLAGS); 
    FLAGS = (int*)balloc((long)sizeof(int) * (size+1)); 
    BPRINT("s;i;s", "\006START ", maxiter, "\012 ITERATION"); 
    STIME_("\01300:00:00.00"); 
    it_1 = maxiter; 
    
    for (iter = 1; iter <= it_1; ++iter) 
{ 
   count = 0; 
   it_2 = size; 

   for (i = 0; i <= it_2; ++i) 
   { 
     FLAGS[i] = true; 
   } 
   it_3 = size; 

   for (i = 0; i <= it_3; ++i) 
   { 
     if (FLAGS[i] != true) 
       goto l_1210; 
     prime = i + i + 3; 
     k = i + prime; 
     while (k <= size) 
     { 
        FLAGS[k] = false; 
        k = k + prime; 
     } 
     count = count + 1; 
    
     l_1210:; 
    } 
} 
    BPRINT("s;s", "\010Time is ", TIME_(&st_1)); 
    BPRINT("i;s", count, "\007 PRIMES"); 
    bexit(0); 
    bexit(0); 
} 




Listing 3: BASIC source code for a root-seeking program

1010 DEFDBL A-H,P-Z
1020 DEFINT I-O
1030 DEF FNF(X) = EXP(X) - 3*X*X
1040 CLS
1050 INPUT "Enter guess : ";X : PRINT
1060 DATA 1.0E-08, 50
1070 READ Accuracy, MAX.ITER
1075 Iter = 0
1076 Diverge% = 1
1077 Diff = 2 * Accuracy
1078 WHILE ABS(Diff) > Accuracy
1080 ' Start root seeking method
1090   H = 0.01
1100   IF ABS(X) > 1 THEN H = H * X
1110   Diff = 2 * H * FNF(X) / (FNF(X+H) - FNF(X-H))
1120   X = X - Diff
1130   Iter = Iter + 1
1140   IF Iter > MAX.ITER THEN Diverge% = 0
1150 WEND
1155 IF (Diverge% = 0) THEN Accuracy = 10 * Accuracy : GOTO 1075
1160 PRINT USING "Root = +#.#######^^^^";X : PRINT
1170 PRINT USING "Number of iterations = ##";Iter : PRINT
1180 PRINT USING "Accuracy = #.###^^^^";Accuracy : PRINT
1190 END




Listing 4: Translated C source code for a root-seeking program

typedef struct data 
    { 
    unsigned d_line; 
    char *d_text; 
    }DATA; 
static DATA da_1[] = {1060, "1.0E-08, 50\n"}; 
double ABS(), EXP(), f_raise(); 
static int divergeI, iter, max_iter, n; 
static double accuracy, diff, f, f0, f1, f2, h, x, x2; 
DATA *data_stmts[] =  
    { 
    da_1, 0 
    }; 
main(argc, argv) 
    int argc; 
    char *argv[]; 
    { 
    bio_init(argc, argv, 1); 
    CLS(); 
    
l_1040:; 
    INPUT("P ;i", "\035Enter function number [1..3] ", &n); 
    BPRINT(""); 
     if (-((n < 1)) | -((n > 3))) 
        goto l_1040; 
    INPUT("P ;d", "\016Enter guess : ", &x); 
    BPRINT(""); 
    BREAD(" d,i", &accuracy, &max_iter); 
    
l_1075:; 
    iter = 0; 
    divergeI = 1; 
    diff = 2 * accuracy; 
    while (ABS(diff) > accuracy) 
	{ 
	/* Start root seeking method */
	h = 0.01; 
	 if (ABS(x) > 1) 
	    h = h * x; 
	x2 = x; 
	pr_1200(); 
	f0 = f; 
	x2 = x + h; 
	pr_1200(); 
	f1 = f; 
	x2 = x - h; 
	pr_1200(); 
	f2 = f; 
	diff = 2 * h * f0 / (f1 - f2); 
	x = x - diff; 
	iter = iter + 1; 
	 if (iter > max_iter) 
	    divergeI = 0; 
	} 
     if ((divergeI == 0)) 
	{ 
	accuracy = 10 * accuracy; 
	goto l_1075; 
	} 
    UPRINT("\025Root = +#.#######^^^^", "d", x); 
    BPRINT(""); 
    UPRINT("\032Number of iterations = ###", "i", iter); 
    BPRINT(""); 
    UPRINT("\024Accuracy = #.###^^^^", "d", accuracy); 
    BPRINT(""); 
    bexit(0); 
    } 

pr_1200() 
    { 
    /* Subroutine to handle function catalogue */
    switch (n) 
	{ 
	case 1: 
	pr_2100(); 
	break; 
	case 2: 
	pr_2200(); 
	break; 
	case 3: 
	pr_2300(); 
	break; 
	
	} 
    return; 
/* Subroutine number 1 */
        } 

pr_2100() 
    { 
    f = EXP(x2) - 3 * f_raise(x2, (double) 2); 
    return; 
/* Subroutine # 2 */
        } 

pr_2200() 
    { 
    f = f_raise(x2, (double) 2) - 5 * x2 + 6; 
    return; 
/* Subroutine # 3 */
        } 

pr_2300() 
    { 
    f = f_raise(x2, (double) 3) - 5 * x2 + 10; 
    return; 
    bexit(0); 
    } 




Listing 5: BASIC source code for Find/Replace utility.

1000 ' Batch Find/Replace Utility  Version 1.1  2/7/86
1010 ' IBM PC                  BASICA version 2.0
1020 ' Copyright (c) 1987  Namir Clement Shammas
1030 '---------------------------------------------------
1040 OPTION BASE 1
1050 DEFINT A-Z
1060 DIM FILENAME$(20),FIND.STR$(30)
1070 DIM REPLACE.STR$(30),REPLACE.FLAG(30),TEXT.LINE$(500)
1080 '
1090 TRUE  = 1 : FALSE = 0 'Set true/false
1100 MAX.LINES = 500 ' Current maximum number of lines read from a file
1110 MAX.STRINGS = 30 ' Number of find/replace strings
1120 MAX.FILES = 20 ' Maximum number of files
1140 CLS
1150 '
1160 T$ = "BATCH FILE FIND/REPLACE PROGRAM" : GOSUB 2290
1170 T$ = "VERSION 1.0" : GOSUB 2290 : PRINT : PRINT
1180 GOSUB 1560 'GET.FILENAMES : Get filenames
1190 GOSUB 1820 'GET.STRINGS : Get search/replace strings
1200 FOR K = 1 TO NUM.FILES
1210   GOSUB 2060 ' READ.LINES: Read text lines from a file
1220   CHANGED = FALSE
1230   FOR I = 1 TO NUM.STRINGS
1240     FOUND = FALSE
1250     FOR J = 1 TO NUM.LINES
1260         PTR = INSTR(TEXT.LINE$(J),FIND.STR$(I))
1270         WHILE PTR > 0 
1280            IF (FOUND = TRUE) THEN 1330
1290               FOUND = TRUE
1300               LPRINT
1310               LPRINT "KEYWORD : ";FIND.STR$(I)
1330            LPRINT J;":";TEXT.LINE$(J)
1340            IF (REPLACE.FLAG(I) = FALSE) THEN 1440
1350                 CHANGED = TRUE
1360                 FIRST$ = ""
1370                 IF PTR > 1 THEN FIRST$ = MID$(TEXT.LINE$(J),1,(PTR-1))
1380                 LAST$ = ""
1390                 IF (PTR+LEN(FIND.STR$(I))) <= LEN(TEXT.LINE$(J))
                                                            THEN 1420
1400                     LAST$ = MID$(TEXT.LINE$(J),(PTR+LEN(FIND.STR$(I))))
1420                 TEXT.LINE$(J) = FIRST$ + REPLACE.STR$(I) + LAST$
1440             PTR = INSTR(PTR+1,TEXT.LINE$(J),FIND.STR$(I))
1450        WEND
1460    NEXT J
1470  NEXT I
1480 IF (CHANGED = TRUE) THEN GOSUB 2190 ' WRITE.LINES
1490 NEXT K
1500 
1510 LPRINT CHR$(140) ' form feed
1520 
1530 END
1540 
1550 '--------------------------------------------------
1560 ' GET.FILENAMES:  Subroutine to input filenames from the keyboard
1570 NUM.FILES = 0
1580 WHILE (NUM.FILES <= 0) OR (NUM.FILES > MAX.FILES)
1590     INPUT "Enter number of files ";NUM.FILES
1600     PRINT 
1610 WEND
1620 FOR I = 1 TO NUM.FILES
1630 'REPEAT.LOOP1:
1640       PRINT "Enter filename # ";I;" ";
1650       INPUT FILENAME$(I) : PRINT
1660       ON ERROR GOTO 1750
1670       OPEN "I",1,FILENAME$(I)
1680       CLOSE #1
1690       ON ERROR GOTO 0
1700    IF FILENAME$(I) = "" THEN 1630
1710 NEXT I
1720 RETURN 
1740 '-------------------------------------------------
1750 'HANDLE: Error hander for bad filenames
1760 PRINT "File ";FILENAME$(I);" was not found"
1770 PRINT
1780 FILENAME$(I) = ""
1790 RESUME NEXT
1800 
1810 '--------------------------------------------------
1820 ' GET.STRINGS: Subroutines to input search/replace strings
1830 NUM.STRINGS = 0
1840 WHILE (NUM.STRINGS <= 0) OR (NUM.STRINGS > MAX.STRINGS)
1850     INPUT "Enter number of search/replace strings ";NUM.STRINGS
1860     PRINT 
1870 WEND
1880 FOR I = 1 TO NUM.STRINGS
1890     REPLACE.STR$(I) = ""
1900     PRINT : PRINT "For string # ";I
1910     INPUT "    Enter string ";FIND.STR$(I)
1920     INPUT "    R)eplace F)ind ";A$ : PRINT
1930     IF (INSTR("Rr",MID$(A$,1,1)) = 0) THEN REPLACE.FLAG(I) = 
                                    FALSE ELSE REPLACE.FLAG(I) = TRUE
1980     IF REPLACE.FLAG(I) = FALSE THEN 2020
1990         INPUT "Enter replacement string ";REPLACE.STR$(I)
2000         PRINT
2020 NEXT I
2030 RETURN
2040 
2050 '--------------------------------------------------
2060 ' READ.LINES: Subroutines to read text lines
2070 LPRINT
2080 LPRINT "PROCESSING FILE : ";FILENAME$(K)
2090 OPEN "I",1,FILENAME$(K)
2100 NUM.LINES = 0
2110 WHILE (NOT EOF(1)) AND (NUM.LINES <= MAX.LINES)
2120    NUM.LINES = NUM.LINES + 1
2130    LINE INPUT #1,TEXT.LINE$(NUM.LINES)
2140 WEND
2150 CLOSE #1
2160 RETURN  
2180 '-------------------------------------------------
2190 ' WRITE.LINES: Subroutines to write text lines
2200 OPEN "O",1,FILENAME$(K)
2210 FOR I = 1 TO NUM.LINES
2220   PRINT #1,TEXT.LINE$(I)
2230 NEXT I
2240 CLOSE #1
2250 RETURN
2270 '--------------------------------------------------
2280 ' Subroutine to center a message
2290 PRINT SPC(40 - LEN(T$)\2);T$
2300 RETURN




Listing 6: Translated C source code for Find/Replace utility.

extern int on_error, err_code, err_stmt, trap_line, trap_err; 
char *CHR_(), *MID_(), *s_asgn(), *s_cat(); 
int EOF(), INSTR(), LEN(); 
static int AREPLACE_FLAG[31], changed, false, found, i, j, k, max_files; 
static int max_lines, max_strings, num_files, num_lines, num_strings, ptr; 
static int true; 
static char *FILENAME_[21], *FIND_STR_[31], *REPLACE_STR_[31]; 
static char *TEXT_LINE_[501], *a_, *first_, *last_, *t_; 
static int it_1, it_2, it_3, it_4, it_5, it_6; 
static char *st_1, *st_2; 

main(argc, argv) 
    int argc; 
    char *argv[]; 
    { 
    bio_init(argc, argv, 1); 
    /* Batch Find/Replace Utility  Version 1.1  2/7/86 */
    /* IBM PC                  BASICA version 2.0 */
    /* Copyright (c) 1987  Namir Clement Shammas */
    /* --------------------------------------------------- */
    free_sp(FILENAME_, 21, 'S'); 
    free_sp(FIND_STR_, 31, 'S'); 
    free_sp(REPLACE_STR_, 31, 'S'); 
    free_sp(TEXT_LINE_, 501, 'S'); 
    
    true = 1; 
    false = 0; /* Set true/false */
    max_lines = 500; /* Current maximum number of lines read from a file */
    max_strings = 30; /* Number of find/replace strings */
    max_files = 20; /* Maximum number of files */
    CLS(); 
    
    t_ = s_asgn(t_, "\037BATCH FILE FIND/REPLACE PROGRAM"); 
    sub_push(1); 
    goto l_2290; 
g_1:; 
    t_ = s_asgn(t_, "\013VERSION 1.0"); 
    sub_push(2); 
    goto l_2290; 
g_2:; 
E_0:;
    BPRINT(""); 
    if (err_code) {err_stmt=0; goto err_trap;}
E_1:;
    BPRINT(""); 
    if (err_code) {err_stmt=1; goto err_trap;}
E_2:;
    sub_push(3); /* GET.FILENAMES : Get filenames */
    goto l_1560; 
g_3:; 
    sub_push(4); /* GET.STRINGS : Get search/replace strings */
    goto l_1820; 
g_4:; 
    it_1 = num_files; 
    
    for (k = 1; k <= it_1; ++k) 
	{ 
	sub_push(5); /* READ.LINES: Read text lines from a file */
	goto l_2060; 
g_5:; 
	changed = false; 
	it_2 = num_strings; 
	
	for (i = 1; i <= it_2; ++i) 
	    { 
	    found = false; 
	    it_3 = num_lines; 
	    
	    for (j = 1; j <= it_3; ++j) 
		{ 
E_3:;
		ptr = INSTR(-1, TEXT_LINE_[j], FIND_STR_[i]); 
    if (err_code) {err_stmt=3; goto err_trap;}
E_4:;
		while (ptr > 0) 
		    { 
		     if ((found == true)) 
			goto l_1330; 
		    found = true; 
E_5:;
		    BLPRINT(""); 
    if (err_code) {err_stmt=5; goto err_trap;}
E_6:;
		    BLPRINT("s;s", "\012KEYWORD : ", FIND_STR_[i]); 
    if (err_code) {err_stmt=6; goto err_trap;}
E_7:;    

l_1330:; 
		    BLPRINT("i;s;s", j, "\001:", TEXT_LINE_[j]); 
    if (err_code) {err_stmt=7; goto err_trap;}
E_8:;
		     if ((AREPLACE_FLAG[i] == false)) 
			goto l_1440; 
		    changed = true; 
		    first_ = s_asgn(first_, "\000"); 
		     if (ptr > 1) 
			{ 
E_9:;
			first_ = s_asgn(first_, MID_(&st_1, TEXT_LINE_[j],
			 1, (ptr - 1))); 
    if (err_code) {err_stmt=9; goto err_trap;}
E_10:;
			} 
		    last_ = s_asgn(last_, "\000"); 
		     if ((ptr + LEN(FIND_STR_[i])) <= LEN(TEXT_LINE_[j])) 
			goto l_1420; 
E_11:;
		    last_ = s_asgn(last_, MID_(&st_1, TEXT_LINE_[j], (ptr
		     + LEN(FIND_STR_[i])), -1)); 
    if (err_code) {err_stmt=11; goto err_trap;}
E_12:;
		    
l_1420:; 
		    TEXT_LINE_[j] = s_asgn(TEXT_LINE_[j], s_cat(&st_2, s
                                                                _cat(&st_1,
		     first_, REPLACE_STR_[i]), last_)); 
    if (err_code) {err_stmt=12; goto err_trap;}
E_13:;
		    
l_1440:; 
		    ptr = INSTR(ptr + 1, TEXT_LINE_[j], FIND_STR_[i]); 
    if (err_code) {err_stmt=13; goto err_trap;}
E_14:;
		    } 
		} 
	    } 
	 if ((changed == true)) 
	    { /* WRITE.LINES */
	    sub_push(6); /* WRITE.LINES */
	    goto l_2190; 
g_6:; 
	    } 
	} 
E_15:;
    BLPRINT("s", CHR_(&st_1, 140)); /* form feed */
    if (err_code) {err_stmt=15; goto err_trap;}
E_16:;
        bexit(0); 
/* -------------------------------------------------- */
    
l_1560:; 
    /* GET.FILENAMES:  Subroutine to input filenames from the keyboard */
    num_files = 0; 
    while (-((num_files <= 0)) | -((num_files > max_files))) 
	{ 
E_17:;
	INPUT("P ;i", "\026Enter number of files ", &num_files); 
    if (err_code) {err_stmt=17; goto err_trap;}
E_18:;
    	BPRINT(""); 
    if (err_code) {err_stmt=18; goto err_trap;}
E_19:;
	} 
    it_4 = num_files; 
    
    for (i = 1; i <= it_4; ++i) 
	{ 
	
l_1630:; 
	/* REPEAT.LOOP1: */
E_20:;
	BPRINT("s;i;s;", "\021Enter filename # ", i, "\001 "); 
    if (err_code) {err_stmt=20; goto err_trap;}
E_21:;
    	INPUT(" s", &FILENAME_[i]); 
    if (err_code) {err_stmt=21; goto err_trap;}
E_22:;
    	BPRINT(""); 
    if (err_code) {err_stmt=22; goto err_trap;}
E_23:;
	on_error = 1; 
	err_code = 0; 
	trap_line = 1; 
E_24:;
	BOPEN("\001I", 1, FILENAME_[i], -1); 
    if (err_code) {err_stmt=24; goto err_trap;}
E_25:;
    	BCLOSE(1, 0); 
	if (trap_err) 
	    { 
	    xer_msg(trap_err); 
	    bexit(1); 
	    } 
	on_error = 0; 
	err_code = 0; 
	 if (s_comp(FILENAME_[i], "\000") == 0) 
	    goto l_1630; 
	} 
    goto sub_ret; 
/* ------------------------------------------------- */

l_1750:; 
    /* HANDLE: Error hander for bad filenames */
E_26:;
    BPRINT("s;s;s", "\005File ", FILENAME_[i], "\016 was not found"); 
    if (err_code) {err_stmt=26; goto err_trap;}
E_27:;
    BPRINT(""); 
    if (err_code) {err_stmt=27; goto err_trap;}
E_28:;
    FILENAME_[i] = s_asgn(FILENAME_[i], "\000"); 
    ++err_stmt; 
    goto un_trap; 
/* -------------------------------------------------- */
    
l_1820:; 
    /* GET.STRINGS: Subroutines to input search/replace strings */
    num_strings = 0; 
    while (-((num_strings <= 0)) | -((num_strings > max_strings))) 
	{ 
E_29:;
	INPUT("P ;i", "\047Enter number of search/replace strings ",
                                                    &num_strings); 
    if (err_code) {err_stmt=29; goto err_trap;}
E_30:;
	BPRINT(""); 
    if (err_code) {err_stmt=30; goto err_trap;}
E_31:;
    	} 
    it_5 = num_strings; 
    
    for (i = 1; i <= it_5; ++i) 
	{ 
	REPLACE_STR_[i] = s_asgn(REPLACE_STR_[i], "\000"); 
E_32:;
	BPRINT(""); 
    if (err_code) {err_stmt=32; goto err_trap;}
E_33:;
	BPRINT("s;i", "\015For string # ", i); 
    if (err_code) {err_stmt=33; goto err_trap;}
E_34:;
	INPUT("P ;s", "\021    Enter string ", &FIND_STR_[i]); 
    if (err_code) {err_stmt=34; goto err_trap;}
E_35:;
	INPUT("P ;s", "\023    R)eplace F)ind ", &a_); 
    if (err_code) {err_stmt=35; goto err_trap;}
E_36:;
	BPRINT(""); 
    if (err_code) {err_stmt=36; goto err_trap;}
E_37:;
    	 if ((INSTR(-1, "\002Rr", MID_(&st_1, a_, 1, 1)) == 0)) 
	    { 
	    AREPLACE_FLAG[i] = false; 
	    } 
	 else 
	    { 
	    AREPLACE_FLAG[i] = true; 
	    } 
	 if (AREPLACE_FLAG[i] == false) 
	    goto l_2020; 
E_38:;
	INPUT("P ;s", "\031Enter replacement string ", &REPLACE_STR_[i]); 
    if (err_code) {err_stmt=38; goto err_trap;}
E_39:;
	BPRINT(""); 
    if (err_code) {err_stmt=39; goto err_trap;}
E_40:;

l_2020:; 
	} 
    goto sub_ret; 
/* -------------------------------------------------- */
    
l_2060:; 
    /* READ.LINES: Subroutines to read text lines */
E_41:;
    BLPRINT(""); 
    if (err_code) {err_stmt=41; goto err_trap;}
E_42:;
    BLPRINT("s;s", "\022PROCESSING FILE : ", FILENAME_[k]); 
    if (err_code) {err_stmt=42; goto err_trap;}
E_43:;
    BOPEN("\001I", 1, FILENAME_[k], -1); 
    if (err_code) {err_stmt=43; goto err_trap;}
E_44:;
        num_lines = 0; 
    while ((~(EOF(1))) & -((num_lines <= max_lines))) 
	{ 
	num_lines = num_lines + 1; 
E_45:;
	INPUT("FLl", 1, &TEXT_LINE_[num_lines]); 
    if (err_code) {err_stmt=45; goto err_trap;}
E_46:;
    	} 
    BCLOSE(1, 0); 
    goto sub_ret; 
/* ------------------------------------------------- */
    
l_2190:; 
    /* WRITE.LINES: Subroutines to write text lines */
E_47:;
    BOPEN("\001O", 1, FILENAME_[k], -1); 
    if (err_code) {err_stmt=47; goto err_trap;}
E_48:;
    it_6 = num_lines; 
    
    for (i = 1; i <= it_6; ++i) 
	{ 
E_49:;
	BFPRINT(1, "s", TEXT_LINE_[i]); 
    if (err_code) {err_stmt=49; goto err_trap;}
E_50:;	} 
    BCLOSE(1, 0); 
    goto sub_ret; 
/* -------------------------------------------------- */
    /* Subroutine to center a message */
E_51:;

l_2290:; 
    BPRINT("b;s", 40 - LEN(t_) / 2, t_); 
    if (err_code) {err_stmt=51; goto err_trap;}
E_52:;
    goto sub_ret; 
    bexit(0); 

    sub_ret: 
    switch(sub_pop())  
	{ 
	case 1: goto g_1; 
	case 2: goto g_2; 
	case 3: goto g_3; 
	case 4: goto g_4; 
	case 5: goto g_5; 
	case 6: goto g_6; 
	} 
    
err_trap: if (trap_err) 
	{ 
	xer_msg(err_code); 
	bexit(1); 
	} 
    trap_err = err_code; 
    err_code = 0; 
    goto l_1750; 
    
un_trap: if (!trap_err) 
	{ 
	xer_msg(-99); 
	bexit(1); 
	} 
    trap_err = err_code = 0; 
    switch(err_stmt) 
	{ 
	case 0: goto E_0; 
	case 1: goto E_1; 
	case 2: goto E_2; 
	case 3: goto E_3; 
	case 4: goto E_4; 
	case 5: goto E_5; 
	case 6: goto E_6; 
	case 7: goto E_7; 
	case 8: goto E_8; 
	case 9: goto E_9; 
	case 10: goto E_10; 
	case 11: goto E_11; 
	case 12: goto E_12; 
	case 13: goto E_13; 
	case 14: goto E_14; 
	case 15: goto E_15; 
	case 16: goto E_16; 
	case 17: goto E_17; 
	case 18: goto E_18; 
	case 19: goto E_19; 
	case 20: goto E_20; 
	case 21: goto E_21; 
	case 22: goto E_22; 
	case 23: goto E_23; 
	case 24: goto E_24; 
	case 25: goto E_25; 
	case 26: goto E_26; 
	case 27: goto E_27; 
	case 28: goto E_28; 
	case 29: goto E_29; 
	case 30: goto E_30; 
	case 31: goto E_31; 
	case 32: goto E_32; 
	case 33: goto E_33; 
	case 34: goto E_34; 
	case 35: goto E_35; 
	case 36: goto E_36; 
	case 37: goto E_37; 
	case 38: goto E_38; 
	case 39: goto E_39; 
	case 40: goto E_40; 
	case 41: goto E_41; 
	case 42: goto E_42; 
	case 43: goto E_43; 
	case 44: goto E_44; 
	case 45: goto E_45; 
	case 46: goto E_46; 
	case 47: goto E_47; 
	case 48: goto E_48; 
	case 49: goto E_49; 
	case 50: goto E_50; 
	case 51: goto E_51; 
	case 52: goto E_52; 
	} 
    } 


