/*-------------------------------------------------------------------------
	getpixel.c
	Returns the value of pixel h, v in the bitmap "bmap".
	Written in 68000 inline assembly both because it is faster
	and because it is quite easy to do.  A version of this code
	was used by Mike Morton in his StarFlight program.
	
	This version has the following limitations:
	
	1.  It assumes that the cursor will not be in the way,
	i.e. it has either been hidden or we are looking at an off-screen
	bitmap.  In the contour map algorithm we are looking at an
	off-screen bitmap.
	
	2.  This version also assumes that the coordinates at the upper left
	are (0,0). Any offset to the coordinate system (by a call to SetOrigin)
	is ignored.
	
	3.  This code will probably not work on the screen buffer for large screen
	Macs, color Macs, gray scale Macs, etc.  It works fine on off-screen bitmaps
	on my Mac II, as long as the depth is 1 bit per pixel.
		
	William May
	303A Ridgefield Circle
	Clinton, MA 01510
	
	Created:	1/20/87
	Modified:	3/21/87		Found a bug: getpixel wouldn't handle
							bitmaps > 32K.
  ------------------------------------------------------------------------*/

#include <QuickDraw.h>
#include <asm.h>

#include "getpixel.h"

int getpixel(h, v, bmap)
int h, v;
BitMap *bmap;
{
	asm {
		move.w	v,d0				; load v and h into registers
		ext.l	d0
		move.w	h,d1
		ext.l	d1
		move.w	d1,d2				; copy h coord for bit offset
									; only need low order byte

		move.l	bmap,a0				; point to bitmap
		
		mulu	OFFSET(BitMap,rowBytes)(a0),d0
									; v * rowbytes is offset to row
		lsr.l	#3,d1				; extract byte offset
		add.l	d1,d0
		not.b	d2					; make bit number 68000 style
		move.l	OFFSET(BitMap,baseAddr)(a0),a0
									; get base address of bitmap
		add.l	d0,a0				; get to the correct byte
		btst	d2,(a0)				; test the bit
		beq		@0
		
		moveq	#1,d0				; set value to 1
		return
@0
		moveq	#0,d0				; set value to 0
	}
}
