;         R32COMP.ASM - 32 bit sqr , compares CPU, NDP
;         By Ray Mariella, 30 March 87 - increments the upper 16 bits
;                                         0000:7FFF to FFFF:7FFF
;         requires 8087 or 80287
           page    ,96
.8087
;
crlf      macro
          mov    dl,13
          call   char_out
          mov    dl,10
          call   char_out
          endm
;
time_print macro byte_var, byte_string
          local plenty
          mov    dl,byte_string             ;output a colon or period
          call   char_out
          cmp    byte_var,9
          ja     plenty
          mov    dl,'0'                     ;space holder if var<10
          call   char_out
plenty:   mov    al,byte_var                ;minutes, secs, or hnds
          xor    ah,ah
          call   dec_out
          endm
;
;
data      segment  public 'DATA'
          even                          
base             dw  10                       ;base to print the numbers in
BIGGUN           dq  ?
rootp            dd  ?
uper             db  ?
secs             db  ?
hnds             db  ?
announc          db  ' 65535 increments of upper 16, CPU then 8087 ',13,10,'$'
data      ends
;
;
stack     segment   stack
                 dw  64  dup(?)       
stack     ends
;
;
code      segment  public 'CODE'
         assume cs:code, ds:data, ss:stack
;
sqrt:     push   bp
          mov    ax,data
          mov    ds,ax
          mov    bp,offset biggun
crlf
          mov    dx,offset announc
          mov    ah,9                    ;print string function
          int    21h                     ;DOS interrrupt
;
          mov    si,32767
          xor    di,di
goodies:  call  update
;
;      square root procedure via 8086, DI:SI
;
CPU:      mov    bx,1                   ;guess1
          mov    dx,di                  ;guess2
          mov    ax,si
biggest:  or     dx,dx
          jz     words
          rcr    dx,1                   ;upper 16/2
          rcr    ax,1                   ;lower 16/2 + carry from upper
          shl    bx,1                   ;guess1*2
          jmp    short biggest
                                        ;next is for guess1 and guess2 16 bits
words:    or     bx,bx
          jnz    checkem                ;if all 32 were used, CF is set
          mov    bx,65535               ;in case all 32 bits were used
;
checkem:  mov    dx,ax                  ;guess2 ax,dx
          mov    cx,bx                  ;guess1 bx,cx
;
logit:    shl    cx,1                   ;guess1
          jc     average                ;necessary for very large integers
          cmp    cx,dx                  ;larger than guess2?
          jae    average                ;if not, guess2/2
          shr    dx,1
          mov    ax,dx
          mov    bx,cx
          jmp    short logit
                                        ;ready for averaging
average:
          add    bx,ax
          rcr    bx,1                   ;average value
Newton:   
          REPT   2
          mov    ax,si           ;lower 16
          mov    dx,di           ;prepare for division, upper 16 in dx
          cmp    bx,dx                  ;needed for really BIG ints
          je     quit                   ; "
          div    bx              ;ax still has target, bx first guess
          add    bx,ax           ;newton
          rcr    bx,1
          endm
;
quit:     inc    di
          jz     done
          jmp    CPU
;
done:     call   update
;          
;         square root via 8087
;  if you need roots of 7FFF:FFFF and less, BIGGUN can be 32 bits, 
;  and ROOTP can be a 16 bits.  The extra length is needed here because
;  the 8087 does not expect unsigned integers.
;
          xor    di,di                  ;8087 loads from memory, 
          mov    ds:[bp],si             ;not regs directly
NDP:      mov    ds:[bp+2],di
         fild   biggun                 ;put integer into 8087 stack
         fsqrt
         fistp  rootp                  ;store to memory, too
         fwait
;
; we now have an 8087 square root =rootp
;
          inc    di
          jnz    NDP 
 
          call   update
          pop    bp
          xor    al,al
          mov    ah,4Ch
          int    21h
;
;
;         output a hex word in decimal
;
;         CX,AX,DX destroyed
;
dec_out   proc   near
          xor    cx,cx
another:  inc    cx
          xor    dx,dx
          div    base                   ;base is 10 decimal!
          push   dx                     ;remainder is less sig digits
          or     ax,ax                  ;is the quotient zero?
          jnz    another                ;if not, more number to convert
print_dig:
          pop    dx                     ;retrive digit from stack
          add    dl,'0'                 ;ascii offset
          call   char_out
          loop   print_dig              ;do all of the digits
          ret
dec_out   endp
;
;         output a single character
;
char_out  proc   near
          mov    ah,2                   ;output char function
          int    21h                    ;do it
          ret
char_out  endp
;
;
update    proc  near
          mov    ah,2ch                 ;get dos time
          int    21h                    ;hour in ch, mins in cl,secs in dh
          mov    uper,cl
          mov    secs,dh
          mov    hnds,dl
          mov    al,ch
          xor    ah,ah
          call   dec_out
;
          time_print uper,':'
;
          time_print secs,':'
;
          time_print hnds,'.'
;
          crlf
          ret
update    endp
;
code      ends 
          end    sqrt   


