#include <stdio.h>                                                                           
#include <stdlib.h>                                                                          
#include <string.h>                                                                          
#include <malloc.h>                                                                          
                                                                                             
#include "loc.h"                                                                             
#include "externs.h"                                                                         
                                                                                             
#define  BUFSIZE  256                                                                        
                                                                                             
                                                                                             
SEG_DESCRIPTOR *build_seg_list()                                                             
{                                                                                            
   int count ;                                                                               
   unsigned long  start_seg, end_seg, length;                                                
   char  seg_name[32], class[32] ;                                                           
   char  *buf ;                                                                              
                                                                                             
   SEG_DESCRIPTOR *p, *previous, *list_start, *class_start ;                                 
                                                                                             
   /*                                                                                        
      This function is responsible for the processing of the link map.                       
      The link map is read and the segment information such as segment                       
      name, segment length and class name are recorded.                                      
   */                                                                                        
                                                                                             
   /* Seek to the beginning of the file */                                                   
   if (fseek(map_file, 0L, SEEK_SET) != 0)   {                                               
      perror(__FILE__) ;                                                                     
      exit(1) ;                                                                              
   }                                                                                         
                                                                                             
   /* Allocate some memory for the line buffer */                                            
   if ((buf = malloc(BUFSIZE)) == NULL)   {                                                  
      perror(__FILE__) ;                                                                     
      exit(1) ;                                                                              
   }                                                                                         
                                                                                             
   /* Search thru the file looking for the start of the segment informati/                   
   while (1)   {                                                                             
      if (fgets(buf, BUFSIZE, map_file) == NULL)   {                                         
         fprintf(stderr, "Unable to find the segment list in %s\n", map_f;                   
         exit(1) ;                                                                           
      }                                                                                      
                                                                                             
      if (strstr(strupr(buf), "START") != NULL)                                              
         break ;                                                                             
   }                                                                                         
                                                                                             
   /* Scan to the start of the first segment record */                                       
   while (fgets(buf, BUFSIZE, map_file) != NULL)   {                                         
      count = sscanf(buf, " %lxH %lxH %lxH %s %s", &start_seg, &end_seg, ;                   
      if (count == 5)                                                                        
         break ;                                                                             
   }                                                                                         
                                                                                             
   /* Check if EOF was detected and an error message should be printed */                    
   if (feof(map_file))   {                                                                   
      fprintf(stderr, "Unable to find the segment list in %s\n", map_fnam;                   
      exit(1) ;                                                                              
   }                                                                                         
                                                                                             
   /* Begin processing the list of segments */                                               
   p = previous = NULL ;                                                                     
   while (count == 5)   {                                                                    
      /* Allocate some memory to hold the data structure */                                  
      if ((p = (SEG_DESCRIPTOR *) malloc(sizeof (*p))) == NULL)   {                          
         perror(__FILE__) ;                                                                  
         exit(1) ;                                                                           
      }                                                                                      
                                                                                             
      if (previous == NULL)                                                                  
         list_start = p ;                                                                    
      else                                                                                   
         previous->next = p ;                                                                
                                                                                             
      strcpy(p->name, strupr(seg_name)) ;                                                    
      strcpy(p->class, strupr(class)) ;                                                      
      p->vseg = (unsigned int) start_seg / 16 ;                                              
      p->offset = (unsigned int) start_seg % 16 ;                                            
      p->len = (unsigned int) length ;                                                       
      p->position = start_seg ;                                                              
      p->inited = FALSE ;                                                                    
      p->romable = FALSE ;                                                                   
      p->symbols = 0 ;                                                                       
      p->symbol_list = NULL ;                                                                
      p->next = NULL ;                                                                       
                                                                                             
      /* Check if the class name has changed and reset the offset */                         
      if (strcmp(p->class, class_start->class) != 0)   {                                     
         p->pseg = 0 ;                                                                       
         class_start = p ;                                                                   
      }                                                                                      
      else                                                                                   
         p->pseg = p->vseg - class_start->vseg ;                                             
                                                                                             
      previous = p;                                                                          
                                                                                             
      /* Read the next line of segment information */                                        
      fgets(buf, BUFSIZE, map_file) ;                                                        
      count = sscanf(buf, " %lxH %lxH %lxH %s %s", &start_seg, &end_seg, ;                   
   }                                                                                         
                                                                                             
   free(buf) ;                                                                               
   return (list_start) ;                                                                     
}                                                                                            