#include <stdio.h>                                                                            
#include "kernel.h"                                                                           
                                                                                              
/* TDEBUG.C     Various routines that are useful for debugging but                            
 *              probably won't end up in the final system.                                    
 */                                                                                           
                                                                                              
t_tprint( t )                                                                                 
TCB     *t;                                                                                   
{                                                                                             
    /* Print a TCB */                                                                         
                                                                                              
    char  **p, *str ;                                                                         
    int   i;                                                                                  
                                                                                              
    printf("----------------- <%s> at %04x ----------------\n",                               
                                                    t->tag, t );                              
                                                                                              
    printf("stack %04x:%04x, priority %d, timestamp %d,",                                     
                     t->ss,t->sp, t->priority, t->timestamp );                                
                                                                                              
    printf(" wait %d, status %d\n", t->wait, t->status );                                     
                                                                                              
    printf("next %04x, initial sp %04x, msg %04x ",                                           
                                t->next, t->initial_sp, t->msg );                             
    pstr( t->msg, 10 );                                                                       
                                                                                              
    printf("stack[ 0] @ %04x = %04x,  ",                                                       
                                &(t->stack)[0], (t->stack)[0]);                               
    printf("stack[ 1] @ %04x = %04x\n\n",                                                      
                                &(t->stack)[1], (t->stack)[1]);                               
                                                                                              
    /* Print the top 15 elements of the stack */                                              
                                                                                              
    i = 15;                                                                                   
    for( p = (char **)t->sp; p < t->initial_sp && --i>=0; p++ )                               
    {                                                                                         
        printf("   sp[%2d] @ %04x = %04x = ",                                                  
                                (char **)t->sp - p, p, *p);                                   
        pstr( *p, 32 );                                                                       
    }                                                                                         
                                                                                              
    if( i < 0 )                                                                               
        printf("(Stack dump truncated at 15 elements)\n");                                    
                                                                                              
    printf("-----------------------------------------------\n");                              
}                                                                                             
                                                                                              
/*------------------------------------------------------------*/                              
                                                                                              
static pstr( str, len )                                                                       
char    *str;                                                                                 
{                                                                                             
    /* Print a string with dots instead of nonprinting                                        
     * characteres                                                                            
     */                                                                                       
                                                                                              
    putchar('<');                                                                             
                                                                                              
    for( len = 32 ; --len>=0 && *str ; str++ )                                                
            putchar( ' ' <= *str && *str < 0x7f ? *str : '.' );                               
                                                                                              
    printf(">\n");                                                                            
}                                                                                             
                                                                                              
/*------------------------------------------------------------*/                              
                                                                                              
t_qprint( q )                                                                                 
T_QUEUE *q ;                                                                                  
{                                                                                             
    /* Print out the contents of a queue */                                                   
                                                                                              
    TCB *t;                                                                                   
    int i;                                                                                    
                                                                                              
    if( q->signature != TQ_SIG )                                                              
    {                                                                                         
            printf("Queue is invalid (bad signature)\n");                                     
            return;                                                                           
    }                                                                                         
                                                                                              
    printf("-------------- Queue at %04x ----------------\n", q);                             
    printf("%d/%d messages in queue, next queue at %04x\n",                                   
                                q->numele, q->q_size, q->next );                              
                                                                                              
    printf("Waiting tasks: ");                                                                
    if( t = q->task_h )                                                                       
        printf("(none)\n" );                                                                  
    else                                                                                      
    {                                                                                         
        for( ; t ; t = t->next )                                                              
        {                                                                                     
            printf( "%s, ", t->tag );                                                         
            if( t == q->task_t )                                                              
                    printf("(end)\n");                                                        
        }                                                                                     
        printf("\n");                                                                         
    }                                                                                         
                                                                                              
    printf( "head = &queue[%d], tail = &queue[%d], queue is:\n",                              
                     q->headp - q->queue, q->tailp - q->queue);                               
                                                                                              
    for( i = 0; i < q->q_size ; i++ )                                                         
    {                                                                                         
            printf("queue[%d]: %04x ", i, q->queue[i] );                                      
            pstr( q->queue[i], 32 );                                                          
    }                                                                                         
    printf("------------------------------------------------\n");                             
}                                                                                             