



 #include <stdio.h>
 #include <fcntl.h>
 #include <ctype.h>
 
 /*  Binary file dump utility. Usage is:
  *   fdump file...   Dump all files listed on command line
  *   fdump +N file   Start N bytes from start of file
  *   fdump -N file   Start N bytes from end of file.
  */
 
 extern long     lseek( int, long, int );
 
 /*--------------------------------------------------------*/
 
 #define BUFSIZE 16
 #define CR      0x0d
 #define LF      0x0a
 #define C_CR    0x11    /* Print left arrow for CR      */
 #define C_LF    0x19    /* Print down arrow for LF      */
 
 #define isprinting(c) (' ' <= (c)  &&  (c) <= '~')
 
 static   long   Bytenum = 0L;
 
 /*--------------------------------------------------------*/
 
 main(argc, argv)
 int     argc;
 char    **argv;
 {
     register int fd;
     long         offset = 0L;
 
     if( argc == 1 )
         usage();
 
     ++argv;
     --argc;
 
     if( **argv == '-' || **argv == '+' )
     {
         if( !isdigit( argv[0][1] ) )
             usage();
 
         offset = atoi( argv[0] );
 
         ++argv;
         --argc;
     }
 
     for(; --argc >= 0 ; ++argv )
     {
         if( (fd = open( *argv, O_RDONLY | O_BINARY)) == -1 ) 
             perror( *argv );
         else
         {
             if( offset > 0 )
                     Bytenum = lseek( fd, offset, SEEK_SET );
 
             else if( offset < 0 )
                     Bytenum = lseek( fd, offset, SEEK_END );
 
             dofile( fd );
             close ( fd );
         }
     }
 
     exit(0);
 }
 
 /*--------------------------------------------------------*/
 
 usage()
 {
     fprintf(stderr, "Usage fdump [+|- N] file...\n");
     fprintf(stderr, "+N   Start dump at byte N\n");
     fprintf(stderr, "-N   Start dump N bytes from EOF\n");
     exit( 1 );
 }
 
 /*--------------------------------------------------------*/
 
 dofile( fd )
 int     fd;
 {
         static   char   buf[ BUFSIZE ];
         register char   nbytes;
 
         while( (nbytes = read(fd, buf, BUFSIZE)) > 0 )
                 doline( buf, nbytes );
 }
 
 /*--------------------------------------------------------*/
 
 doline( buf, nbytes )
 char    *buf;
 {
     static   char       hex[] = "0123456789abcdef" ;
     register int        i;
     register char       *p;
 
     printf("%06lx: ", Bytenum );
     Bytenum += nbytes;
 
     for( i = 1, p = buf ; i <= BUFSIZE ; i++ , p++ )
     {
             if( i <= nbytes )
             {
                     putchar( hex[ (*p >> 4) & 0xf ] );
                     putchar( hex[  *p       & 0xf ] );
             }
             else
             {
                     putchar( ' ' );
                     putchar( ' ' );
             }
 
             putchar( ' ' );
     }
 
     putchar(' ');
 
     for( i = 1, p = buf ; i <= nbytes ; i++ , p++ )
     {
             if( *p == CR )
                     putchar( C_CR );
 
             else if( *p == LF )
                     putchar( C_LF );
             else
                     putchar( isprinting(*p) ? *p : '.' );
     }
 
     putchar('\n');
     putchar('\r');
 }

