"market.st (Version 1.0 -- 02/25/90 -- KEA)

This file installs the Market Simulation application.  To install
 this application evaluate the following expression:

    Smalltalk at: #FileInDir put: Disk.
    (Disk file: 'market.st') fileIn; close.
    Smalltalk removeKey: #FileInDir

 To open the Market Simulation window evaluate the following expression:

    MarketWindow new open.
"!


"*************************************************************************
The following code loads the animation images:"! 

(Smalltalk includesKey:#MarketImages)
    ifFalse:[Smalltalk at:#MarketImages put:(Dictionary new:7)].!


| keys fileNames key aFile type wid hgt aForm bitmap index |

CursorManager execute change.

keys :=         #(  'PersonUp'      'PersonRight'
                    'PersonLeft'    'PersonDown'
                    'Customer'      'CustomerReaching'
                    'Counter').

fileNames :=    #(  'prsnup.frm'    'prsnrght.frm'
                    'prsnleft.frm'  'prsndown.frm'
                    'customer.frm'  'custrchg.frm'
                    'counter.frm').

Transcript cr;  show:'Filing in animation images';  cr.

1 to:keys size do:[:i|
    key    := keys at:i.

    Transcript show:'...', key, ' (', (fileNames at:i), ')';  cr.

    aFile  := Disk file:(fileNames at:i).
    type   := aFile nextLine.
    wid    := aFile nextLine asInteger.
    hgt    := aFile nextLine asInteger.
    aForm  := Form width:wid height:hgt.
    bitmap := aForm bitmap.
    index  := 1.
    [aFile atEnd  or:[index > bitmap size]]
        whileFalse:[
            bitmap at:index put:aFile nextWord asInteger.
            index := index + 1].
    MarketImages at:key put:aForm].

CursorManager normal change.!

"*************************************************************************
The following code loads the application classes:"!


| classes aClass name aFileStream |

CursorManager execute change.

classes := #(   EmptyMenu
                RandomNumber
                MarketActor
                    Customer
                    Checker
                    Bagger
                CheckoutCounter
                MarketSimulator
                MarketWindow).
Transcript
    cr;
    show:'Installing the Market Simulation classes';
    cr.
classes do:[:class|
    (Smalltalk includesKey:class)
        ifTrue:[
            aClass := Smalltalk at:class.
            Transcript show:'  ', aClass name, ' exists';  cr.]
        ifFalse:[
            aClass := class printString.
            name := File fileName:aClass extension:'cls'.
            Transcript show:'  ', aClass, ' -- ', name;  cr.
            aFileStream := Disk file:name.
            aFileStream
                fileIn;
                close]].
Transcript
    show:'Done installing application classes';  cr;  cr.

CursorManager normal change.!
