
Object subclass: #MarketActor
  instanceVariableNames: 
    'running msgQueue position notify '
  classVariableNames: ''
  poolDictionaries: '' !

!MarketActor class methods !

extent  
    ^self form extent.!

form  
    ^self formNamed:self imageName.!

formNamed:anImageName  
    ^MarketImages at:anImageName.!

height  
    ^self form height.!

imageName  
    ^'PersonUp'.!

new  
    ^super new initialize.!

priority
    ^2.!

width  
    ^self form width.! !


!MarketActor methods !

alternateForm  
    ^self formNamed:self class alternateImageName.!

animate 
    self display:self alternateForm.!

display  
    self display:self form at:position.!

display:aForm 
    self display:aForm at:position.!

display:aForm at:aPoint  
    aForm displayAt:aPoint.!

erase 
    Display white:self frame.!

extent  
    ^self class extent.!

form  
    ^self class form.!

formNamed:anImageName  
    ^self class formNamed:anImageName.!

frame 
    ^position extent:self extent.!

height  
    ^self class height.!

initialize
    msgQueue := MessageQueue new.
    running  := false.!

messageQueue
    ^msgQueue.!

moveBy:delta  
    self moveTo:position + delta.!

moveTo:aPoint  
    self  
        erase;  
        position:aPoint;  
        display.!

notify  
    (notify isKindOf:Semaphore)  
        ifTrue:[notify signal].!

position:aPoint  
    position := aPoint.!

priority
    ^self class priority.!

receive
    ^msgQueue receive.!

release
    msgQueue release.  msgQueue := nil.  notify := nil.
    super release.!

run
    |action|
    [running]
        whileTrue:[
            action := self receive.
            (running and:[self respondsTo:action])
                ifTrue:[self perform:action]].
    self shutdown.!

send:aMessage to:anObject
    self send:aMessage to:anObject with:nil.!

send:aMessage to:anObject with:anArgument
    |queue|
    (queue := anObject messageQueue) isNil
        ifFalse:[
            queue send:aMessage.
            anArgument isNil
            ifFalse:[queue send:anArgument]].
    Processor yield.!

shutdown
    self erase;  notify.!

sleep:numberOfSeconds
    |timeout|
    timeout := Time now asSeconds + numberOfSeconds.
    [running and:[Time now asSeconds < timeout]]
        whileTrue:[Processor yield].!

start
    running
        ifFalse:[
            running := true.
            [self run] forkAt:self priority].!

stop:notifySemaphore
    notify := notifySemaphore.
    running
        ifTrue:[
            running := false.
            self send:#wakeUp to:self]
        ifFalse:[self notify].!

wakeUp
        "In case the receiver is waiting
         at the message queue."!

width  
    ^self class width.! !
