
Object subclass: #MarketWindow
  instanceVariableNames: 
    'topPane aPane simulator '
  classVariableNames: 
    'Version Frame Title '
  poolDictionaries: '' !

!MarketWindow class methods !

initialize 
    Frame   := Display boundingBox insetBy:16.
    Title   := 'Market Checkout Simulation'.
    Version := ' (Version 1.0 -- 02/24/90 -- KEA)'.!

new 
    self initialize. 
    ^super new.! !


!MarketWindow methods !

close 
    self stop.!

initPane:aFrame 
    Display white:aFrame. 
    self initSimulator:aFrame. 
    ^Form fromDisplay:aFrame.!

initSimulator:aFrame 
    simulator isNil 
        ifTrue:[ 
            simulator := MarketSimulator new 
                reframe:aFrame; 
                yourself].!

open 
    topPane := TopPane new 
        model:self; 
        label:Title, Version; 
        menu:#windowMenu; 
        rightIcons:#(collapse); 
        yourself. 
    topPane addSubpane: 
        (aPane := GraphPane new 
            model:self; 
            name:#initPane:; 
            menu:#paneMenu; 
            framingRatio:(0 @ 0 extent:1 @ 1)). 
    topPane reframe:Frame. 
    topPane dispatcher openWindow scheduleWindow.!

paneMenu 
    (simulator isNil or:[simulator running]) 
        ifTrue:[^EmptyMenu new] 
        ifFalse:[ 
            ^Menu 
                labels:'START SIMULATION' 
                lines:#() 
                selectors:#(start)].!

start 
    simulator start.!

stop
    |semaphore|
    simulator isNil
        ifFalse:[
            CursorManager execute change.
            semaphore := Semaphore new.
            simulator stop:semaphore.
            semaphore wait;  release.
            simulator release.  simulator := nil.
            CursorManager normal change].!

windowMenu 
    ^Menu 
        labels:'cycle\collapse\close' withCrs 
        lines:#() 
        selectors:#(cycle collapse closeIt).! !
