/***
*       GASystem
*       Mike Morrow
*       September 1989
***/



/**
*	Header file for GA stuff
**/


#ifndef GA_H

#if __STDC__
# define CONST const
#else
# define CONST
#endif


	/**
	*	We assume that "long ints" can hold at least 32 bits of precision,
	*	"ints" can hold at least 16 bits.
	**/





	/**
	*	Objective functions return this type of value.  A GENE's fitness
	*	is of this type.
	**/
typedef unsigned long int	FIT_TYPE;


	/**
	*	A GENE's genetic pattern is contained in a SEQ (sequence).
	**/
typedef char SEQ_COMPONENT;
typedef SEQ_COMPONENT *SEQ;

	/**
	*	Here's how we represent genes
	**/
typedef struct
{
	FIT_TYPE	gene_fit;			/* current fitness value	*/
	int			gene_tag;			/* misc.					*/
	SEQ			gene_seq;			/* the acutal genetic sequence */
}GENE;



/***
*	These are the routines that the user must supply.
*		objinit() is called once at program start up.
*		objective() will be called often to get a fitness value
*			for SEQ s.
*		objshow() is called when the user requests to see a gene SEQ.
*		objdumpdone() is called at the end of a group of objshow()s.
*			It allows the display formatter to segregate logical
*			blocks of display.
***/

#if __STDC__
extern void objinit();
extern FIT_TYPE objective(SEQ s, int len);
extern void objshow(SEQ s, int len, FIT_TYPE fitness);
extern void objdumpdone();
#else
extern void objinit();
extern FIT_TYPE objective();
extern void objshow();
extern void objdumpdone();
#endif


#define GA_H

#endif /* ifndef GA_H */
